﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>
#include <nn/friends/detail/ipc/friends_ServiceConfig.h>

namespace nn { namespace friends { namespace detail { namespace service {

class NotificationService;

}}}}

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      通知イベントのハンドラーです。
*/
class NotificationEventHandler
{
private:
    NN_DISALLOW_COPY(NotificationEventHandler);
    NN_DISALLOW_MOVE(NotificationEventHandler);

public:
    /*!
        @brief      登録できる通知の最大数です。
    */
    static const int NotificationCountMax = detail::ipc::NotificationServiceCountMax;

private:
    /*!
        @brief      コンストラクタです。
    */
    NotificationEventHandler() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static NotificationEventHandler& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(NotificationEventHandler, s_Instance);
        return s_Instance;
    }

    /*!
        @brief      通知サービスを登録します。

        @param[in]  notification    通知サービス。

        @pre
            - notification != nullptr
    */
    void Attach(NotificationService* notification) NN_NOEXCEPT;

    /*!
        @brief      通知サービスを登録解除します。

        @param[in]  notification    通知サービス。

        @pre
            - notification != nullptr
    */
    void Detach(NotificationService* notification) NN_NOEXCEPT;

    /*!
        @brief      フレンドリストの更新を通知します。

        @param[in]  uid ユーザーアカウント。
    */
    void NotifyFriendListUpdated(const nn::account::Uid& uid) NN_NOEXCEPT;

    /*!
        @brief      フレンドプレゼンスの更新を通知します。

        @param[in]  uid         ユーザーアカウント。
        @param[in]  accountId   対象ユーザー。
    */
    void NotifyFriendPresenceUpdated(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;

    /*!
        @brief      フレンド申請の受信を通知します。

        @param[in]  uid ユーザーアカウント。
    */
    void NotifyFriendRequestReceived(const nn::account::Uid& uid) NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    NotificationService* m_Notifications[NotificationCountMax];
};

}}}}}
