﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      各種データの検証器です。
*/
class DataVerifier
{
public:
    /*!
        @brief      文字列が妥当かどうかを検証します。

        @param[in]  string      文字列。
        @param[in]  maxLength   最大バイト数。

        @return     文字列が妥当かどうか。
    */
    static bool VerifyString(const char* string, size_t maxLength) NN_NOEXCEPT;

    /*!
        @brief      文字列が妥当かどうかを検証します。

        @param[in]  string      文字列。
        @param[in]  maxLength   最大バイト数。
        @param[in]  maxCount    最大文字数。

        @return     文字列が妥当かどうか。
    */
    static bool VerifyString(const char* string, size_t maxLength, int maxCount) NN_NOEXCEPT;

    /*!
        @brief      アプリ内表示名が妥当かどうかを検証します。

        @param[in]  name    アプリ内表示名。

        @return     アプリ内表示名が妥当かどうか。
    */
    static bool VerifyInAppScreenName(const InAppScreenName& name) NN_NOEXCEPT;

    /*!
        @brief      Mii 画像 URL パラメータが妥当かどうかを検証します。

        @param[in]  param   Mii 画像 URL パラメータ。

        @return     Mii 画像 URL パラメータが妥当かどうか。
    */
    static bool VerifyMiiImageUrlParam(const MiiImageUrlParam& param) NN_NOEXCEPT;

    /*!
        @brief      時刻が妥当かどうかを検証します。

        @param[in]  posixTime   時刻。

        @return     時刻が妥当かどうか。
    */
    static bool VerifyPosixTime(const nn::time::PosixTime& posixTime) NN_NOEXCEPT;

    /*!
        @brief      フレンドコードが妥当かどうかを検証します。

        @param[in]  friendCode  フレンドコード。

        @return     フレンドコードが妥当かどうか。
    */
    static bool VerifyFriendCode(const FriendCode& friendCode) NN_NOEXCEPT;

    /*!
        @brief      プレイログが妥当かどうかを検証します。

        @param[in]  playLog プレイログ。

        @return     プレイログが妥当かどうか。
    */
    static bool VerifyPlayLog(const PlayLog& playLog) NN_NOEXCEPT;

    /*!
        @brief      ユーザー設定が妥当かどうかを検証します。

        @param[in]  setting ユーザー設定。

        @return     ユーザー設定が妥当かどうか。
    */
    static bool VerifyUserSetting(const UserSettingImpl& setting) NN_NOEXCEPT;
};

}}}}}
