﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/account/account_Types.h>

namespace nn { namespace friends { namespace detail { namespace ipc {

//// FriendService

/*!
    @brief      1 プロセスあたりの FriendService 数です。
*/
const int FriendServiceCountPerProcess = 4;

/*!
    @brief      FriendService の最大数です。

    @details
                内訳は以下のとおりです。

                - アプリケーション … 4
                - マイページ … 2
                - ホームメニュー … 1
                - オーバーレイ … 1
                - システムプロセス … 1
                - 予約 … 7
*/
const int FriendServiceCountMax = 16;

//// NotificationService

/*!
    @brief      1 プロセスあたりの NotificationService 数です。
*/
const int NotificationServiceCountPerProcess = nn::account::UserCountMax;

/*!
    @brief      NotificationService の最大数です。

    @details
                内訳は以下のとおりです。

                - アプリケーション … nn::account::UserCountMax
                - 予約 … 8
*/
const int NotificationServiceCountMax = 16;

//// DaemonSuspendSessionService

/*!
    @brief      1 プロセスあたりの DaemonSuspendSessionService 数です。
*/
const int DaemonSuspendSessionServiceCountPerProcess = 1;

/*!
    @brief      DaemonSuspendSessionService の最大数です。

    @details
                内訳は以下のとおりです。

                - システムプロセス … 1
                - 予約 … 3
*/
const int DaemonSuspendSessionServiceCountMax = 4;

//// Session

/*!
    @brief      1 プロセスあたりのセッション数です。
*/
const int SessionCountPerProcess = FriendServiceCountPerProcess;

/*!
    @brief      システムが提供するセッション数です。
*/
const int SessionCountMax = 8;

//// Object

/*!
    @brief      1 プロセスあたりのオブジェクト数です。

    @details
                サービス生成器＋各オブジェクトの総数 になります。
*/
const int ObjectCountPerProcess = 1 + FriendServiceCountPerProcess + NotificationServiceCountPerProcess + DaemonSuspendSessionServiceCountPerProcess;

}}}}
