﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_Types.h>

namespace nn { namespace friends { namespace detail { namespace ipc {

/*!
    @brief      PresenceStatusFilter のサイズ固定版です。
*/
enum SizedPresenceStatusFilter : int32_t
{
    SizedPresenceStatusFilter_None               = 0,
    SizedPresenceStatusFilter_Online             = 1,
    SizedPresenceStatusFilter_OnlinePlay         = 2,
    SizedPresenceStatusFilter_OnlineOrOnlinePlay = 3
};

/*!
    @brief      NotificationType のサイズ固定版です。
*/
enum SizedNotificationType : int32_t
{
    SizedNotificationType_Unkown                 = 0,
    SizedNotificationType_FriendListUpdated      = 1,
    SizedNotificationType_FriendPresenceUpdated  = 2,

    SizedNotificationType_FriendRequestReceived  = 101
};

/*!
    @brief      FriendFilter のサイズ固定版です。
*/
struct SizedFriendFilter
{
    SizedPresenceStatusFilter presenceStatus;
    bool isFavoriteOnly;
    bool isSameAppPresenceOnly;
    bool isSameAppPlayedOnly;
    bool isArbitraryAppPlayedOnly;
    Bit64 presenceGroupId;

    void Box(const FriendFilter& filter) NN_NOEXCEPT
    {
        presenceStatus = static_cast<SizedPresenceStatusFilter>(filter.presenceStatus);
        isFavoriteOnly = filter.isFavoriteOnly;
        isSameAppPresenceOnly = filter.isSameAppPresenceOnly;
        isSameAppPlayedOnly = filter.isSameAppPlayedOnly;
        isArbitraryAppPlayedOnly = filter.isArbitraryAppPlayedOnly;
        isArbitraryAppPlayedOnly = filter.isArbitraryAppPlayedOnly;
        presenceGroupId = filter.presenceGroupId;
    }

    FriendFilter Unbox() NN_NOEXCEPT
    {
        FriendFilter filter;

        filter.presenceStatus = static_cast<PresenceStatusFilter>(presenceStatus);
        filter.isFavoriteOnly = isFavoriteOnly;
        filter.isSameAppPresenceOnly = isSameAppPresenceOnly;
        filter.isSameAppPlayedOnly = isSameAppPlayedOnly;
        filter.isArbitraryAppPlayedOnly = isArbitraryAppPlayedOnly;
        filter.isArbitraryAppPlayedOnly = isArbitraryAppPlayedOnly;
        filter.presenceGroupId = presenceGroupId;

        return filter;
    }
};

/*!
    @brief      NotificationInfo のサイズ固定版です。
*/
struct SizedNotificationInfo
{
    SizedNotificationType type;
    Bit8 reserved[4];
    nn::account::NetworkServiceAccountId accountId;

    void Box(const NotificationInfo& info) NN_NOEXCEPT
    {
        type = static_cast<SizedNotificationType>(info.type);
        accountId = info.accountId;
    }

    NotificationInfo Unbox() NN_NOEXCEPT
    {
        NotificationInfo info;

        info.type = static_cast<NotificationType>(type);
        info.accountId = accountId;

        return info;
    }
};

}}}}
