﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/friends/detail/ipc/friends_IFriendService.sfdl.h>
#include <nn/friends/detail/ipc/friends_INotificationService.sfdl.h>
#include <nn/friends/detail/ipc/friends_IDaemonSuspendSessionService.sfdl.h>

namespace nn { namespace friends { namespace detail { namespace ipc {

/*!
    @brief      IPC サービスの初期化を行います。
*/
void Initialize() NN_NOEXCEPT;

/*!
    @brief      IPC サービスの終了処理を行います。
*/
void Finalize() NN_NOEXCEPT;

/*!
    @brief      FriendService を作成します。

    @param[out] outService  FriendService。

    @return     処理結果。
*/
nn::Result CreateFriendService(IFriendService** outService) NN_NOEXCEPT;

/*!
    @brief      NotificationService を作成します。

    @param[out] outService  NotificationService。
    @param[in]  uid         ユーザーアカウント。

    @return     処理結果。
*/
nn::Result CreateNotificationService(INotificationService** outService, const nn::account::Uid& uid) NN_NOEXCEPT;

/*!
    @brief      DaemonSuspendSessionService を作成します。

    @param[out] outService  DaemonSuspendSessionService。

    @return     処理結果。
*/
nn::Result CreateDaemonSuspendSessionService(IDaemonSuspendSessionService** outService) NN_NOEXCEPT;

}}}}
