﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_Setting.h>
#include <nn/friends/detail/friends_MacrosImpl.h>
#include <nn/friends/detail/friends_ImplProfileExtra.h>

namespace nn { namespace friends { namespace detail {

NN_DETAIL_FRIENDS_BEGIN_IMPL(UserSetting)
{
    // 16
    nn::account::Uid uid;
    // 4
    int32_t presencePermission;
    // 4
    int32_t playLogPermission;
    // 1
    bool friendRequestReception;
    // 7
    NN_PADDING7;
    // 32
    FriendCode friendCode;
    // 8
    nn::time::PosixTime friendCodeNextIssuableTime;
    // 1024
    ProfileExtraImpl profileExtra;
}
NN_DETAIL_FRIENDS_END_IMPL(UserSetting);

NN_DETAIL_FRIENDS_BEGIN_IMPL(FriendSetting)
{
    // 16
    nn::account::Uid uid;
    // 8
    nn::account::NetworkServiceAccountId accountId;
    // 1
    bool favorite;
    // 1
    bool newly;
    // 1
    bool onlineNotification;
    // 5
    NN_PADDING5;
    // 8
    NN_PADDING8;
}
NN_DETAIL_FRIENDS_END_IMPL(FriendSetting);

}}}
