﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      fatal モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_FATAL_TRACE(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_TRACE_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_TRACE_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_TRACE_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_FATAL_INFO(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_INFO_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_INFO_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_INFO_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_FATAL_WARN(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_WARN_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_WARN_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_WARN_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_FATAL_ERROR(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_ERROR_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_ERROR_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_ERROR_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_FATAL_FATAL(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_FATAL_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_FATAL_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_FATAL_FATAL_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(fatal, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_FATAL_VTRACE(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Trace, 0, format, args)
#define NN_DETAIL_FATAL_VTRACE_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Trace, 1, format, args)
#define NN_DETAIL_FATAL_VTRACE_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Trace, 2, format, args)
#define NN_DETAIL_FATAL_VTRACE_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Trace, 3, format, args)

#define NN_DETAIL_FATAL_VINFO(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Info, 0, format, args)
#define NN_DETAIL_FATAL_VINFO_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Info, 1, format, args)
#define NN_DETAIL_FATAL_VINFO_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Info, 2, format, args)
#define NN_DETAIL_FATAL_VINFO_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Info, 3, format, args)

#define NN_DETAIL_FATAL_VWARN(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Warn, 0, format, args)
#define NN_DETAIL_FATAL_VWARN_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Warn, 1, format, args)
#define NN_DETAIL_FATAL_VWARN_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Warn, 2, format, args)
#define NN_DETAIL_FATAL_VWARN_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Warn, 3, format, args)

#define NN_DETAIL_FATAL_VERROR(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Error, 0, format, args)
#define NN_DETAIL_FATAL_VERROR_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Error, 1, format, args)
#define NN_DETAIL_FATAL_VERROR_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Error, 2, format, args)
#define NN_DETAIL_FATAL_VERROR_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Error, 3, format, args)

#define NN_DETAIL_FATAL_VFATAL(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Fatal, 0, format, args)
#define NN_DETAIL_FATAL_VFATAL_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Fatal, 1, format, args)
#define NN_DETAIL_FATAL_VFATAL_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Fatal, 2, format, args)
#define NN_DETAIL_FATAL_VFATAL_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(fatal, Fatal, 3, format, args)

#define NN_DETAIL_FATAL_PUT_TRACE(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Trace, 0, text, length)
#define NN_DETAIL_FATAL_PUT_TRACE_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Trace, 1, text, length)
#define NN_DETAIL_FATAL_PUT_TRACE_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Trace, 2, text, length)
#define NN_DETAIL_FATAL_PUT_TRACE_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Trace, 3, text, length)

#define NN_DETAIL_FATAL_PUT_INFO(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Info, 0, text, length)
#define NN_DETAIL_FATAL_PUT_INFO_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Info, 1, text, length)
#define NN_DETAIL_FATAL_PUT_INFO_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Info, 2, text, length)
#define NN_DETAIL_FATAL_PUT_INFO_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Info, 3, text, length)

#define NN_DETAIL_FATAL_PUT_WARN(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Warn, 0, text, length)
#define NN_DETAIL_FATAL_PUT_WARN_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Warn, 1, text, length)
#define NN_DETAIL_FATAL_PUT_WARN_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Warn, 2, text, length)
#define NN_DETAIL_FATAL_PUT_WARN_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Warn, 3, text, length)

#define NN_DETAIL_FATAL_PUT_ERROR(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Error, 0, text, length)
#define NN_DETAIL_FATAL_PUT_ERROR_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Error, 1, text, length)
#define NN_DETAIL_FATAL_PUT_ERROR_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Error, 2, text, length)
#define NN_DETAIL_FATAL_PUT_ERROR_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Error, 3, text, length)

#define NN_DETAIL_FATAL_PUT_FATAL(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Fatal, 0, text, length)
#define NN_DETAIL_FATAL_PUT_FATAL_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Fatal, 1, text, length)
#define NN_DETAIL_FATAL_PUT_FATAL_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Fatal, 2, text, length)
#define NN_DETAIL_FATAL_PUT_FATAL_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(fatal, Fatal, 3, text, length)
