﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ファン制御ライブラリ実装部の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace fan {
namespace impl {

//! @name ライブラリの初期化と終了
//! @{

/**
 * @brief ファン制御ライブラリ実装部を初期化します。
 *
 * @post        ライブラリは初期化済の状態になります。
 *
 * @details     ファン制御ライブラリ実装部を初期化します。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief ファン制御ライブラリ実装部を終了します。
 *
 * @post        ライブラリは初期化前の状態になります。
 *
 * @details     ファン制御ライブラリ実装部を終了します。
 */
void Finalize() NN_NOEXCEPT;

//! @}
// ~ライブラリの初期化と終了

} // impl
} // fan
} // nn
