﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 *  @file
 *  @brief Error upload service types.
*/

#include <nn/erpt/erpt_Types.h>

namespace nn    {
namespace eupld {

/**
 *  @brief Structure containing upload status.
 */
struct ReportUploadList
{
    uint32_t reportCount;               //!< Number of report entries in this list.

    /**
     * @brief Structure containing information about single report.
     */
    struct ReportInfo
    {
        nn::erpt::ReportId reportId;    //!< Report id.
        nn::Result         result;      //!< Result code.
    }
    Report[nn::erpt::NumberOfReports];
};

}}
