﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/es/es_ELicenseApi.h>
#include <nn/es/es_ELicenseTypes.h>
#include <nn/es/es_ELicenseTypesForInner.h>
#include <nn/es/es_LocalConcurrencyCheckTypes.h>
#include <nn/es/es_RightsTypes.h>
#include <nn/es/es_Types.h>
#include <nn/es/es_TypesForInner.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace es { // NOLINT(whitespace/braces)

class IActiveRightsContext;

class IETicketService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IActiveRightsContext, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IActiveRightsContext)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetUsersOfAccountRestrictedRights, (const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool anyAccount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterRightsIdList, (const ::nn::sf::InArray<::nn::es::RightsId>& rightsIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CheckRightsIdListValidity)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RemoveUnavailableRightsIds)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListUsingRightsIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::RightsId>& outList, bool isTemporaryOnly))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListUsingELicenseIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseId>& outList, bool isTemporaryOnly, ::nn::es::ELicenseOwnerId ownerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetUsersOfAccountRestrictedRights, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseUserId>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListUsingELicenseOwnerIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseOwnerId>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(BeginUsingActiveRightsContext)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EndUsingActiveRightsContext)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ForceActivateRightsContextForExit)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveRightsContextStatus, (::nn::sf::Out<::std::int32_t> outStatus))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveRightsContextExpiredTime, (::nn::sf::Out<::std::int64_t> outExpiredTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveRightsContextExpiredTimeChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IActiveRightsContext)

        ::nn::Result SetUsersOfAccountRestrictedRights(const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool anyAccount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetUsersOfAccountRestrictedRights, (userIdList, anyAccount));
        }

        ::nn::Result RegisterRightsIdList(const ::nn::sf::InArray<::nn::es::RightsId>& rightsIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterRightsIdList, (rightsIdList));
        }

        ::nn::Result CheckRightsIdListValidity() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CheckRightsIdListValidity);
        }

        ::nn::Result RemoveUnavailableRightsIds() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RemoveUnavailableRightsIds);
        }

        ::nn::Result ListUsingRightsIds(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::RightsId>& outList, bool isTemporaryOnly) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListUsingRightsIds, (outCount, outList, isTemporaryOnly));
        }

        ::nn::Result ListUsingELicenseIds(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseId>& outList, bool isTemporaryOnly, ::nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListUsingELicenseIds, (outCount, outList, isTemporaryOnly, ownerId));
        }

        ::nn::Result GetUsersOfAccountRestrictedRights(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseUserId>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetUsersOfAccountRestrictedRights, (outCount, outList));
        }

        ::nn::Result ListUsingELicenseOwnerIds(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseOwnerId>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListUsingELicenseOwnerIds, (outCount, outList));
        }

        ::nn::Result BeginUsingActiveRightsContext() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(BeginUsingActiveRightsContext);
        }

        ::nn::Result EndUsingActiveRightsContext() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EndUsingActiveRightsContext);
        }

        ::nn::Result ForceActivateRightsContextForExit() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ForceActivateRightsContextForExit);
        }

        ::nn::Result GetActiveRightsContextStatus(::nn::sf::Out<::std::int32_t> outStatus) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActiveRightsContextStatus, (outStatus));
        }

        ::nn::Result GetActiveRightsContextExpiredTime(::nn::sf::Out<::std::int64_t> outExpiredTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActiveRightsContextExpiredTime, (outExpiredTime));
        }

        ::nn::Result GetActiveRightsContextExpiredTimeChangedEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActiveRightsContextExpiredTimeChangedEvent, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IActiveRightsContext
    {
    public:
        nn::Result SetUsersOfAccountRestrictedRights(const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool anyAccount) NN_NOEXCEPT;
        nn::Result RegisterRightsIdList(const nn::sf::InArray<nn::es::RightsId>& rightsIdList) NN_NOEXCEPT;
        nn::Result CheckRightsIdListValidity() NN_NOEXCEPT;
        nn::Result RemoveUnavailableRightsIds() NN_NOEXCEPT;
        nn::Result ListUsingRightsIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::RightsId>& outList, bool isTemporaryOnly) NN_NOEXCEPT;
        nn::Result ListUsingELicenseIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseId>& outList, bool isTemporaryOnly, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
        nn::Result GetUsersOfAccountRestrictedRights(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseUserId>& outList) NN_NOEXCEPT;
        nn::Result ListUsingELicenseOwnerIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseOwnerId>& outList) NN_NOEXCEPT;
        nn::Result BeginUsingActiveRightsContext() NN_NOEXCEPT;
        nn::Result EndUsingActiveRightsContext() NN_NOEXCEPT;
        nn::Result ForceActivateRightsContextForExit() NN_NOEXCEPT;
        nn::Result GetActiveRightsContextStatus(nn::sf::Out<std::int32_t> outStatus) NN_NOEXCEPT;
        nn::Result GetActiveRightsContextExpiredTime(nn::sf::Out<std::int64_t> outExpiredTime) NN_NOEXCEPT;
        nn::Result GetActiveRightsContextExpiredTimeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetUsersOfAccountRestrictedRights(const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool anyAccount) NN_NOEXCEPT;
    nn::Result RegisterRightsIdList(const nn::sf::InArray<nn::es::RightsId>& rightsIdList) NN_NOEXCEPT;
    nn::Result CheckRightsIdListValidity() NN_NOEXCEPT;
    nn::Result RemoveUnavailableRightsIds() NN_NOEXCEPT;
    nn::Result ListUsingRightsIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::RightsId>& outList, bool isTemporaryOnly) NN_NOEXCEPT;
    nn::Result ListUsingELicenseIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseId>& outList, bool isTemporaryOnly, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
    nn::Result GetUsersOfAccountRestrictedRights(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseUserId>& outList) NN_NOEXCEPT;
    nn::Result ListUsingELicenseOwnerIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseOwnerId>& outList) NN_NOEXCEPT;
    nn::Result BeginUsingActiveRightsContext() NN_NOEXCEPT;
    nn::Result EndUsingActiveRightsContext() NN_NOEXCEPT;
    nn::Result ForceActivateRightsContextForExit() NN_NOEXCEPT;
    nn::Result GetActiveRightsContextStatus(nn::sf::Out<std::int32_t> outStatus) NN_NOEXCEPT;
    nn::Result GetActiveRightsContextExpiredTime(nn::sf::Out<std::int64_t> outExpiredTime) NN_NOEXCEPT;
    nn::Result GetActiveRightsContextExpiredTimeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::es::IActiveRightsContext))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetUsersOfAccountRestrictedRights, (const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool anyAccount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetUsersOfAccountRestrictedRights, (userIdList, anyAccount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterRightsIdList, (const ::nn::sf::InArray<::nn::es::RightsId>& rightsIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterRightsIdList, (rightsIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckRightsIdListValidity)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CheckRightsIdListValidity);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RemoveUnavailableRightsIds)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RemoveUnavailableRightsIds);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListUsingRightsIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::RightsId>& outList, bool isTemporaryOnly))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListUsingRightsIds, (outCount, outList, isTemporaryOnly));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListUsingELicenseIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseId>& outList, bool isTemporaryOnly, ::nn::es::ELicenseOwnerId ownerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListUsingELicenseIds, (outCount, outList, isTemporaryOnly, ownerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUsersOfAccountRestrictedRights, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseUserId>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetUsersOfAccountRestrictedRights, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListUsingELicenseOwnerIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseOwnerId>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListUsingELicenseOwnerIds, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(BeginUsingActiveRightsContext)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(BeginUsingActiveRightsContext);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EndUsingActiveRightsContext)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EndUsingActiveRightsContext);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ForceActivateRightsContextForExit)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ForceActivateRightsContextForExit);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveRightsContextStatus, (::nn::sf::Out<::std::int32_t> outStatus))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActiveRightsContextStatus, (outStatus));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveRightsContextExpiredTime, (::nn::sf::Out<::std::int64_t> outExpiredTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActiveRightsContextExpiredTime, (outExpiredTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveRightsContextExpiredTimeChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActiveRightsContextExpiredTimeChangedEvent, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::es::IActiveRightsContext>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::es::IActiveRightsContext))

    // nn::Result SetUsersOfAccountRestrictedRights(const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool anyAccount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetUsersOfAccountRestrictedRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(userIdList, 0, (const ::nn::sf::InArray<::nn::es::ELicenseUserId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (userIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(anyAccount, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (anyAccount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(anyAccount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetUsersOfAccountRestrictedRights)

    // nn::Result RegisterRightsIdList(const nn::sf::InArray<nn::es::RightsId>& rightsIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterRightsIdList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rightsIdList, 0, (const ::nn::sf::InArray<::nn::es::RightsId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (rightsIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterRightsIdList)

    // nn::Result CheckRightsIdListValidity() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckRightsIdListValidity)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckRightsIdListValidity)

    // nn::Result RemoveUnavailableRightsIds() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveUnavailableRightsIds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveUnavailableRightsIds)

    // nn::Result ListUsingRightsIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::RightsId>& outList, bool isTemporaryOnly) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListUsingRightsIds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::es::RightsId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isTemporaryOnly, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isTemporaryOnly))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isTemporaryOnly)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListUsingRightsIds)

    // nn::Result ListUsingELicenseIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseId>& outList, bool isTemporaryOnly, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListUsingELicenseIds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::es::ELicenseId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isTemporaryOnly, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ownerId, (::nn::es::ELicenseOwnerId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isTemporaryOnly, ownerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isTemporaryOnly), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ownerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListUsingELicenseIds)

    // nn::Result GetUsersOfAccountRestrictedRights(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseUserId>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetUsersOfAccountRestrictedRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::es::ELicenseUserId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetUsersOfAccountRestrictedRights)

    // nn::Result ListUsingELicenseOwnerIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseOwnerId>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListUsingELicenseOwnerIds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::es::ELicenseOwnerId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListUsingELicenseOwnerIds)

    // nn::Result BeginUsingActiveRightsContext() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BeginUsingActiveRightsContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BeginUsingActiveRightsContext)

    // nn::Result EndUsingActiveRightsContext() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EndUsingActiveRightsContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EndUsingActiveRightsContext)

    // nn::Result ForceActivateRightsContextForExit() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ForceActivateRightsContextForExit)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ForceActivateRightsContextForExit)

    // nn::Result GetActiveRightsContextStatus(nn::sf::Out<std::int32_t> outStatus) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActiveRightsContextStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStatus, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outStatus))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStatus)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActiveRightsContextStatus)

    // nn::Result GetActiveRightsContextExpiredTime(nn::sf::Out<std::int64_t> outExpiredTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActiveRightsContextExpiredTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outExpiredTime, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outExpiredTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outExpiredTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActiveRightsContextExpiredTime)

    // nn::Result GetActiveRightsContextExpiredTimeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActiveRightsContextExpiredTimeChangedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActiveRightsContextExpiredTimeChangedEvent)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::RightsId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseOwnerId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::es::IActiveRightsContext, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::es::IActiveRightsContext))

    // nn::Result SetUsersOfAccountRestrictedRights(const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool anyAccount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetUsersOfAccountRestrictedRights, (const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool anyAccount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetUsersOfAccountRestrictedRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(anyAccount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetUsersOfAccountRestrictedRights)
    }

    // nn::Result RegisterRightsIdList(const nn::sf::InArray<nn::es::RightsId>& rightsIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterRightsIdList, (const ::nn::sf::InArray<::nn::es::RightsId>& rightsIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterRightsIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterRightsIdList)
    }

    // nn::Result CheckRightsIdListValidity() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckRightsIdListValidity)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckRightsIdListValidity)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckRightsIdListValidity)
    }

    // nn::Result RemoveUnavailableRightsIds() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RemoveUnavailableRightsIds)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveUnavailableRightsIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveUnavailableRightsIds)
    }

    // nn::Result ListUsingRightsIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::RightsId>& outList, bool isTemporaryOnly) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListUsingRightsIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::RightsId>& outList, bool isTemporaryOnly))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListUsingRightsIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isTemporaryOnly)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListUsingRightsIds)
    }

    // nn::Result ListUsingELicenseIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseId>& outList, bool isTemporaryOnly, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListUsingELicenseIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseId>& outList, bool isTemporaryOnly, ::nn::es::ELicenseOwnerId ownerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListUsingELicenseIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isTemporaryOnly)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ownerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListUsingELicenseIds)
    }

    // nn::Result GetUsersOfAccountRestrictedRights(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseUserId>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUsersOfAccountRestrictedRights, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseUserId>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetUsersOfAccountRestrictedRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetUsersOfAccountRestrictedRights)
    }

    // nn::Result ListUsingELicenseOwnerIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseOwnerId>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListUsingELicenseOwnerIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseOwnerId>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListUsingELicenseOwnerIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListUsingELicenseOwnerIds)
    }

    // nn::Result BeginUsingActiveRightsContext() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(BeginUsingActiveRightsContext)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BeginUsingActiveRightsContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BeginUsingActiveRightsContext)
    }

    // nn::Result EndUsingActiveRightsContext() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EndUsingActiveRightsContext)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EndUsingActiveRightsContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EndUsingActiveRightsContext)
    }

    // nn::Result ForceActivateRightsContextForExit() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ForceActivateRightsContextForExit)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ForceActivateRightsContextForExit)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ForceActivateRightsContextForExit)
    }

    // nn::Result GetActiveRightsContextStatus(nn::sf::Out<std::int32_t> outStatus) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveRightsContextStatus, (::nn::sf::Out<::std::int32_t> outStatus))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActiveRightsContextStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStatus)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActiveRightsContextStatus)
    }

    // nn::Result GetActiveRightsContextExpiredTime(nn::sf::Out<std::int64_t> outExpiredTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveRightsContextExpiredTime, (::nn::sf::Out<::std::int64_t> outExpiredTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActiveRightsContextExpiredTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outExpiredTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActiveRightsContextExpiredTime)
    }

    // nn::Result GetActiveRightsContextExpiredTimeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveRightsContextExpiredTimeChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActiveRightsContextExpiredTimeChangedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActiveRightsContextExpiredTimeChangedEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::es::IActiveRightsContext>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::es::IActiveRightsContext))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetUsersOfAccountRestrictedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetUsersOfAccountRestrictedRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(anyAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterRightsIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterRightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rightsIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckRightsIdListValidity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckRightsIdListValidity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveUnavailableRightsIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveUnavailableRightsIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListUsingRightsIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListUsingRightsIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isTemporaryOnly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListUsingELicenseIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListUsingELicenseIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isTemporaryOnly),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ownerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetUsersOfAccountRestrictedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetUsersOfAccountRestrictedRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListUsingELicenseOwnerIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListUsingELicenseOwnerIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BeginUsingActiveRightsContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BeginUsingActiveRightsContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EndUsingActiveRightsContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EndUsingActiveRightsContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ForceActivateRightsContextForExit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ForceActivateRightsContextForExit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActiveRightsContextStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActiveRightsContextStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActiveRightsContextExpiredTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActiveRightsContextExpiredTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outExpiredTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActiveRightsContextExpiredTimeChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActiveRightsContextExpiredTimeChangedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetUsersOfAccountRestrictedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterRightsIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckRightsIdListValidity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveUnavailableRightsIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListUsingRightsIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListUsingELicenseIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetUsersOfAccountRestrictedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListUsingELicenseOwnerIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BeginUsingActiveRightsContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EndUsingActiveRightsContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ForceActivateRightsContextForExit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActiveRightsContextStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActiveRightsContextExpiredTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActiveRightsContextExpiredTimeChangedEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::es::IActiveRightsContext))

namespace nn { namespace es { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IETicketService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IETicketService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ImportTicket, (const ::nn::sf::InBuffer& ticket, const ::nn::sf::InBuffer& certificate))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ImportTicketCertificateSet, (const ::nn::sf::InBuffer& ticketCertificateSet))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteTicket, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeletePersonalizedTicket, (::nn::es::AccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllCommonTicket)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllPersonalizedTicket)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAllPersonalizedTicketExcludingList, (const ::nn::sf::InArray<::nn::es::TicketId>& ticketIdExclusionList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountCommonTicket, (::nn::sf::Out<::std::int32_t> pOutCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountPersonalizedTicket, (::nn::sf::Out<::std::int32_t> pOutCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListCommonTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListPersonalizedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListMissingPersonalizedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::TicketId>& outTicketIdList, const ::nn::sf::InArray<::nn::es::TicketId>& ticketIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketSize, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::es::RightsIdIncludingKeyId& rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketData, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, const ::nn::es::RightsIdIncludingKeyId& rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OwnTicket, (const ::nn::sf::OutArray<bool>& outOwnTicketList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTicketInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::TicketInfo>& outTicketInfoList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListLightTicketInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::LightTicketInfo>& outTicketInfoList, const ::nn::es::RightsIdIncludingKeyId& rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SignData, (::nn::sf::Out<::nn::es::Sign> pOutSign, ::nn::sf::Out<::nn::es::Certificate> pOutCertificate, const ::nn::sf::InBuffer& pData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketAndCertificateSize, (::nn::sf::Out<::std::uint64_t> pOutTicketSize, ::nn::sf::Out<::std::uint64_t> pOutCertificateSize, const ::nn::es::RightsIdIncludingKeyId& rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketAndCertificateData, (::nn::sf::Out<::std::uint64_t> pOutTicketSize, ::nn::sf::Out<::std::uint64_t> pOutCertificateSize, const ::nn::sf::OutBuffer& pOutTicketBuffer, const ::nn::sf::OutBuffer& pOutCertificateBuffer, const ::nn::es::RightsIdIncludingKeyId& rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ImportPrepurchaseRecord, (const ::nn::es::PrepurchaseRecord& record))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeletePrepurchaseRecord, (const ::nn::es::PrepurchaseRecord& record))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllPrepurchaseRecord)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListPrepurchaseRecordInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::PrepurchaseRecord>& outPrepurchaseRecordList, const ::nn::es::RightsIdIncludingKeyId& rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountDesignatedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, ::nn::es::RightsId rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDesignatedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList, ::nn::es::RightsId rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountDesignatedPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount, ::nn::es::RightsId rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDesignatedPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList, ::nn::es::RightsId rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetEncryptedTicketSize, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::es::RightsIdIncludingKeyId& rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetEncryptedTicketData, (::nn::sf::Out<::std::uint64_t> pOutTicketId, ::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, const ::nn::sf::OutBuffer& pOutKey, const ::nn::es::RightsIdIncludingKeyId& rightsId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckRightsStatusIncludingKeyId, (const ::nn::sf::OutArray<::nn::es::RightsStatus>& outStatusList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList, const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckRightsStatus, (const ::nn::sf::OutArray<::nn::es::RightsStatus>& outStatusList, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIdList, const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterTitleKey, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList, const ::nn::sf::InArray<::std::int32_t>& keyGenerationList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllTitleKey)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAccountRestrictedRightsUser, (::nn::es::ELicenseUserId userId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllAccountRestrictedRightsUser)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAccountRestrictedRightsUser, (::nn::sf::Out<bool> outHasAccount, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseUserId>& outUserIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BeginImportELicenseArchive, (::nn::sf::Out<::nn::es::ELicenseImportContext> pOutContext, ::nn::es::ELicenseOwnerId ownerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ImportELicenseArchive, (const ::nn::es::ELicenseImportContext& context, const ::nn::sf::InBuffer& eLicenseArchive))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EndImportELicenseArchive, (::nn::sf::Out<::nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const ::nn::es::ELicenseImportContext& context))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountELicense, (::nn::sf::Out<::std::int32_t> pOutCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListELicenseIds, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseId>& outELicenseIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListELicenseInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseInfoWrapper>& outELicenseInfoList, const ::nn::sf::InArray<::nn::es::ELicenseId>& eLicenseIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListELicenseInfoForDebug, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseInfoForSystemWrapper>& outELicenseInfoList, const ::nn::sf::InArray<::nn::es::ELicenseId>& eLicenseIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EndImportELicenseArchiveForDebug, (::nn::sf::Out<::nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const ::nn::es::ELicenseImportContext& context))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetELicenseArchiveSizeForDebug, (::nn::sf::Out<::std::uint64_t> pOutSize, ::nn::es::ELicenseOwnerId ownerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetELicenseArchiveDataForDebug, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, ::nn::es::ELicenseOwnerId ownerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllELicenseArchiveForDebug)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetChallengeOfLocalConcurrencyCheck, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckChallenge> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AuthorizeLocalConcurrencyCheckData, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckAuthenticationInfo> outInfo, const ::nn::sf::InArray<::nn::es::LocalConcurrencyCheckData>& authenticatedDataList, const ::nn::es::LocalConcurrencyCheckData& unauthenticatedData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalConcurrencyCheckData, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckData> outData, ::nn::es::LocalConcurrencyCheckChallenge challenge))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(VerifyLocalConcurrencyAuthentication, (const ::nn::es::LocalConcurrencyCheckAuthenticationInfo& info))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateActiveRightsContext, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::es::IActiveRightsContext>> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IETicketService)

        ::nn::Result ImportTicket(const ::nn::sf::InBuffer& ticket, const ::nn::sf::InBuffer& certificate) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ImportTicket, (ticket, certificate));
        }

        ::nn::Result ImportTicketCertificateSet(const ::nn::sf::InBuffer& ticketCertificateSet) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ImportTicketCertificateSet, (ticketCertificateSet));
        }

        ::nn::Result DeleteTicket(const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteTicket, (rightsIdList));
        }

        ::nn::Result DeletePersonalizedTicket(::nn::es::AccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeletePersonalizedTicket, (accountId));
        }

        ::nn::Result DeleteAllCommonTicket() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteAllCommonTicket);
        }

        ::nn::Result DeleteAllPersonalizedTicket() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteAllPersonalizedTicket);
        }

        ::nn::Result DeleteAllPersonalizedTicketExcludingList(const ::nn::sf::InArray<::nn::es::TicketId>& ticketIdExclusionList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteAllPersonalizedTicketExcludingList, (ticketIdExclusionList));
        }

        ::nn::Result CountCommonTicket(::nn::sf::Out<::std::int32_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountCommonTicket, (pOutCount));
        }

        ::nn::Result CountPersonalizedTicket(::nn::sf::Out<::std::int32_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountPersonalizedTicket, (pOutCount));
        }

        ::nn::Result ListCommonTicket(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListCommonTicket, (pOutCount, outRightsIdList));
        }

        ::nn::Result ListPersonalizedTicket(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListPersonalizedTicket, (pOutCount, outRightsIdList));
        }

        ::nn::Result ListMissingPersonalizedTicket(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::TicketId>& outTicketIdList, const ::nn::sf::InArray<::nn::es::TicketId>& ticketIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListMissingPersonalizedTicket, (pOutCount, outTicketIdList, ticketIdList));
        }

        ::nn::Result GetCommonTicketSize(::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCommonTicketSize, (pOutSize, rightsId));
        }

        ::nn::Result GetCommonTicketData(::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, const ::nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCommonTicketData, (pOutSize, pOutBuffer, rightsId));
        }

        ::nn::Result OwnTicket(const ::nn::sf::OutArray<bool>& outOwnTicketList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OwnTicket, (outOwnTicketList, rightsIdList));
        }

        ::nn::Result GetTicketInfo(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::TicketInfo>& outTicketInfoList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTicketInfo, (pOutCount, outTicketInfoList, rightsIdList));
        }

        ::nn::Result ListLightTicketInfo(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::LightTicketInfo>& outTicketInfoList, const ::nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListLightTicketInfo, (pOutCount, outTicketInfoList, rightsId));
        }

        ::nn::Result SignData(::nn::sf::Out<::nn::es::Sign> pOutSign, ::nn::sf::Out<::nn::es::Certificate> pOutCertificate, const ::nn::sf::InBuffer& pData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SignData, (pOutSign, pOutCertificate, pData));
        }

        ::nn::Result GetCommonTicketAndCertificateSize(::nn::sf::Out<::std::uint64_t> pOutTicketSize, ::nn::sf::Out<::std::uint64_t> pOutCertificateSize, const ::nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCommonTicketAndCertificateSize, (pOutTicketSize, pOutCertificateSize, rightsId));
        }

        ::nn::Result GetCommonTicketAndCertificateData(::nn::sf::Out<::std::uint64_t> pOutTicketSize, ::nn::sf::Out<::std::uint64_t> pOutCertificateSize, const ::nn::sf::OutBuffer& pOutTicketBuffer, const ::nn::sf::OutBuffer& pOutCertificateBuffer, const ::nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCommonTicketAndCertificateData, (pOutTicketSize, pOutCertificateSize, pOutTicketBuffer, pOutCertificateBuffer, rightsId));
        }

        ::nn::Result ImportPrepurchaseRecord(const ::nn::es::PrepurchaseRecord& record) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ImportPrepurchaseRecord, (record));
        }

        ::nn::Result DeletePrepurchaseRecord(const ::nn::es::PrepurchaseRecord& record) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeletePrepurchaseRecord, (record));
        }

        ::nn::Result DeleteAllPrepurchaseRecord() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteAllPrepurchaseRecord);
        }

        ::nn::Result CountPrepurchaseRecord(::nn::sf::Out<::std::int32_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountPrepurchaseRecord, (pOutCount));
        }

        ::nn::Result ListPrepurchaseRecord(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListPrepurchaseRecord, (pOutCount, outRightsIdList));
        }

        ::nn::Result ListPrepurchaseRecordInfo(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::PrepurchaseRecord>& outPrepurchaseRecordList, const ::nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListPrepurchaseRecordInfo, (pOutCount, outPrepurchaseRecordList, rightsId));
        }

        ::nn::Result CountDesignatedTicket(::nn::sf::Out<::std::int32_t> pOutCount, ::nn::es::RightsId rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountDesignatedTicket, (pOutCount, rightsId));
        }

        ::nn::Result ListDesignatedTicket(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList, ::nn::es::RightsId rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDesignatedTicket, (pOutCount, outRightsIdList, rightsId));
        }

        ::nn::Result CountDesignatedPrepurchaseRecord(::nn::sf::Out<::std::int32_t> pOutCount, ::nn::es::RightsId rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountDesignatedPrepurchaseRecord, (pOutCount, rightsId));
        }

        ::nn::Result ListDesignatedPrepurchaseRecord(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList, ::nn::es::RightsId rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDesignatedPrepurchaseRecord, (pOutCount, outRightsIdList, rightsId));
        }

        ::nn::Result GetEncryptedTicketSize(::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetEncryptedTicketSize, (pOutSize, rightsId));
        }

        ::nn::Result GetEncryptedTicketData(::nn::sf::Out<::std::uint64_t> pOutTicketId, ::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, const ::nn::sf::OutBuffer& pOutKey, const ::nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetEncryptedTicketData, (pOutTicketId, pOutSize, pOutBuffer, pOutKey, rightsId));
        }

        ::nn::Result CheckRightsStatusIncludingKeyId(const ::nn::sf::OutArray<::nn::es::RightsStatus>& outStatusList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList, const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckRightsStatusIncludingKeyId, (outStatusList, rightsIdList, userIdList, onlyAllAccountRights));
        }

        ::nn::Result CheckRightsStatus(const ::nn::sf::OutArray<::nn::es::RightsStatus>& outStatusList, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIdList, const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckRightsStatus, (outStatusList, rightsIdList, userIdList, onlyAllAccountRights));
        }

        ::nn::Result RegisterTitleKey(const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList, const ::nn::sf::InArray<::std::int32_t>& keyGenerationList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterTitleKey, (rightsIdList, keyGenerationList));
        }

        ::nn::Result UnregisterAllTitleKey() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnregisterAllTitleKey);
        }

        ::nn::Result RegisterAccountRestrictedRightsUser(::nn::es::ELicenseUserId userId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterAccountRestrictedRightsUser, (userId));
        }

        ::nn::Result UnregisterAllAccountRestrictedRightsUser() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnregisterAllAccountRestrictedRightsUser);
        }

        ::nn::Result ListAccountRestrictedRightsUser(::nn::sf::Out<bool> outHasAccount, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseUserId>& outUserIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAccountRestrictedRightsUser, (outHasAccount, outCount, outUserIdList));
        }

        ::nn::Result BeginImportELicenseArchive(::nn::sf::Out<::nn::es::ELicenseImportContext> pOutContext, ::nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BeginImportELicenseArchive, (pOutContext, ownerId));
        }

        ::nn::Result ImportELicenseArchive(const ::nn::es::ELicenseImportContext& context, const ::nn::sf::InBuffer& eLicenseArchive) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ImportELicenseArchive, (context, eLicenseArchive));
        }

        ::nn::Result EndImportELicenseArchive(::nn::sf::Out<::nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const ::nn::es::ELicenseImportContext& context) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EndImportELicenseArchive, (pOutELicenseArchiveId, context));
        }

        ::nn::Result CountELicense(::nn::sf::Out<::std::int32_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountELicense, (pOutCount));
        }

        ::nn::Result ListELicenseIds(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseId>& outELicenseIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListELicenseIds, (pOutCount, outELicenseIdList));
        }

        ::nn::Result ListELicenseInfo(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseInfoWrapper>& outELicenseInfoList, const ::nn::sf::InArray<::nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListELicenseInfo, (pOutCount, outELicenseInfoList, eLicenseIdList));
        }

        ::nn::Result ListELicenseInfoForDebug(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseInfoForSystemWrapper>& outELicenseInfoList, const ::nn::sf::InArray<::nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListELicenseInfoForDebug, (pOutCount, outELicenseInfoList, eLicenseIdList));
        }

        ::nn::Result EndImportELicenseArchiveForDebug(::nn::sf::Out<::nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const ::nn::es::ELicenseImportContext& context) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EndImportELicenseArchiveForDebug, (pOutELicenseArchiveId, context));
        }

        ::nn::Result GetELicenseArchiveSizeForDebug(::nn::sf::Out<::std::uint64_t> pOutSize, ::nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetELicenseArchiveSizeForDebug, (pOutSize, ownerId));
        }

        ::nn::Result GetELicenseArchiveDataForDebug(::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, ::nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetELicenseArchiveDataForDebug, (pOutSize, pOutBuffer, ownerId));
        }

        ::nn::Result DeleteAllELicenseArchiveForDebug() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteAllELicenseArchiveForDebug);
        }

        ::nn::Result GetChallengeOfLocalConcurrencyCheck(::nn::sf::Out<::nn::es::LocalConcurrencyCheckChallenge> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetChallengeOfLocalConcurrencyCheck, (outValue));
        }

        ::nn::Result AuthorizeLocalConcurrencyCheckData(::nn::sf::Out<::nn::es::LocalConcurrencyCheckAuthenticationInfo> outInfo, const ::nn::sf::InArray<::nn::es::LocalConcurrencyCheckData>& authenticatedDataList, const ::nn::es::LocalConcurrencyCheckData& unauthenticatedData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AuthorizeLocalConcurrencyCheckData, (outInfo, authenticatedDataList, unauthenticatedData));
        }

        ::nn::Result GetLocalConcurrencyCheckData(::nn::sf::Out<::nn::es::LocalConcurrencyCheckData> outData, ::nn::es::LocalConcurrencyCheckChallenge challenge) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLocalConcurrencyCheckData, (outData, challenge));
        }

        ::nn::Result VerifyLocalConcurrencyAuthentication(const ::nn::es::LocalConcurrencyCheckAuthenticationInfo& info) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(VerifyLocalConcurrencyAuthentication, (info));
        }

        ::nn::Result CreateActiveRightsContext(::nn::sf::Out<::nn::sf::SharedPointer<::nn::es::IActiveRightsContext>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateActiveRightsContext, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IETicketService
    {
    public:
        nn::Result ImportTicket(const nn::sf::InBuffer& ticket, const nn::sf::InBuffer& certificate) NN_NOEXCEPT;
        nn::Result ImportTicketCertificateSet(const nn::sf::InBuffer& ticketCertificateSet) NN_NOEXCEPT;
        nn::Result DeleteTicket(const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT;
        nn::Result DeletePersonalizedTicket(nn::es::AccountId accountId) NN_NOEXCEPT;
        nn::Result DeleteAllCommonTicket() NN_NOEXCEPT;
        nn::Result DeleteAllPersonalizedTicket() NN_NOEXCEPT;
        nn::Result DeleteAllPersonalizedTicketExcludingList(const nn::sf::InArray<nn::es::TicketId>& ticketIdExclusionList) NN_NOEXCEPT;
        nn::Result CountCommonTicket(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
        nn::Result CountPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
        nn::Result ListCommonTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT;
        nn::Result ListPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT;
        nn::Result ListMissingPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::TicketId>& outTicketIdList, const nn::sf::InArray<nn::es::TicketId>& ticketIdList) NN_NOEXCEPT;
        nn::Result GetCommonTicketSize(nn::sf::Out<std::uint64_t> pOutSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        nn::Result GetCommonTicketData(nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        nn::Result OwnTicket(const nn::sf::OutArray<bool>& outOwnTicketList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT;
        nn::Result GetTicketInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::TicketInfo>& outTicketInfoList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT;
        nn::Result ListLightTicketInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::LightTicketInfo>& outTicketInfoList, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        nn::Result SignData(nn::sf::Out<nn::es::Sign> pOutSign, nn::sf::Out<nn::es::Certificate> pOutCertificate, const nn::sf::InBuffer& pData) NN_NOEXCEPT;
        nn::Result GetCommonTicketAndCertificateSize(nn::sf::Out<std::uint64_t> pOutTicketSize, nn::sf::Out<std::uint64_t> pOutCertificateSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        nn::Result GetCommonTicketAndCertificateData(nn::sf::Out<std::uint64_t> pOutTicketSize, nn::sf::Out<std::uint64_t> pOutCertificateSize, const nn::sf::OutBuffer& pOutTicketBuffer, const nn::sf::OutBuffer& pOutCertificateBuffer, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        nn::Result ImportPrepurchaseRecord(const nn::es::PrepurchaseRecord& record) NN_NOEXCEPT;
        nn::Result DeletePrepurchaseRecord(const nn::es::PrepurchaseRecord& record) NN_NOEXCEPT;
        nn::Result DeleteAllPrepurchaseRecord() NN_NOEXCEPT;
        nn::Result CountPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
        nn::Result ListPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT;
        nn::Result ListPrepurchaseRecordInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::PrepurchaseRecord>& outPrepurchaseRecordList, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        nn::Result CountDesignatedTicket(nn::sf::Out<std::int32_t> pOutCount, nn::es::RightsId rightsId) NN_NOEXCEPT;
        nn::Result ListDesignatedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList, nn::es::RightsId rightsId) NN_NOEXCEPT;
        nn::Result CountDesignatedPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, nn::es::RightsId rightsId) NN_NOEXCEPT;
        nn::Result ListDesignatedPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList, nn::es::RightsId rightsId) NN_NOEXCEPT;
        nn::Result GetEncryptedTicketSize(nn::sf::Out<std::uint64_t> pOutSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        nn::Result GetEncryptedTicketData(nn::sf::Out<std::uint64_t> pOutTicketId, nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, const nn::sf::OutBuffer& pOutKey, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
        nn::Result CheckRightsStatusIncludingKeyId(const nn::sf::OutArray<nn::es::RightsStatus>& outStatusList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList, const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT;
        nn::Result CheckRightsStatus(const nn::sf::OutArray<nn::es::RightsStatus>& outStatusList, const nn::sf::InArray<nn::es::RightsId>& rightsIdList, const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT;
        nn::Result RegisterTitleKey(const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList, const nn::sf::InArray<std::int32_t>& keyGenerationList) NN_NOEXCEPT;
        nn::Result UnregisterAllTitleKey() NN_NOEXCEPT;
        nn::Result RegisterAccountRestrictedRightsUser(nn::es::ELicenseUserId userId) NN_NOEXCEPT;
        nn::Result UnregisterAllAccountRestrictedRightsUser() NN_NOEXCEPT;
        nn::Result ListAccountRestrictedRightsUser(nn::sf::Out<bool> outHasAccount, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseUserId>& outUserIdList) NN_NOEXCEPT;
        nn::Result BeginImportELicenseArchive(nn::sf::Out<nn::es::ELicenseImportContext> pOutContext, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
        nn::Result ImportELicenseArchive(const nn::es::ELicenseImportContext& context, const nn::sf::InBuffer& eLicenseArchive) NN_NOEXCEPT;
        nn::Result EndImportELicenseArchive(nn::sf::Out<nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const nn::es::ELicenseImportContext& context) NN_NOEXCEPT;
        nn::Result CountELicense(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
        nn::Result ListELicenseIds(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseId>& outELicenseIdList) NN_NOEXCEPT;
        nn::Result ListELicenseInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseInfoWrapper>& outELicenseInfoList, const nn::sf::InArray<nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT;
        nn::Result ListELicenseInfoForDebug(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseInfoForSystemWrapper>& outELicenseInfoList, const nn::sf::InArray<nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT;
        nn::Result EndImportELicenseArchiveForDebug(nn::sf::Out<nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const nn::es::ELicenseImportContext& context) NN_NOEXCEPT;
        nn::Result GetELicenseArchiveSizeForDebug(nn::sf::Out<std::uint64_t> pOutSize, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
        nn::Result GetELicenseArchiveDataForDebug(nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
        nn::Result DeleteAllELicenseArchiveForDebug() NN_NOEXCEPT;
        nn::Result GetChallengeOfLocalConcurrencyCheck(nn::sf::Out<nn::es::LocalConcurrencyCheckChallenge> outValue) NN_NOEXCEPT;
        nn::Result AuthorizeLocalConcurrencyCheckData(nn::sf::Out<nn::es::LocalConcurrencyCheckAuthenticationInfo> outInfo, const nn::sf::InArray<nn::es::LocalConcurrencyCheckData>& authenticatedDataList, const nn::es::LocalConcurrencyCheckData& unauthenticatedData) NN_NOEXCEPT;
        nn::Result GetLocalConcurrencyCheckData(nn::sf::Out<nn::es::LocalConcurrencyCheckData> outData, nn::es::LocalConcurrencyCheckChallenge challenge) NN_NOEXCEPT;
        nn::Result VerifyLocalConcurrencyAuthentication(const nn::es::LocalConcurrencyCheckAuthenticationInfo& info) NN_NOEXCEPT;
        nn::Result CreateActiveRightsContext(nn::sf::Out<nn::sf::SharedPointer<nn::es::IActiveRightsContext>> pOut) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ImportTicket(const nn::sf::InBuffer& ticket, const nn::sf::InBuffer& certificate) NN_NOEXCEPT;
    nn::Result ImportTicketCertificateSet(const nn::sf::InBuffer& ticketCertificateSet) NN_NOEXCEPT;
    nn::Result DeleteTicket(const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT;
    nn::Result DeletePersonalizedTicket(nn::es::AccountId accountId) NN_NOEXCEPT;
    nn::Result DeleteAllCommonTicket() NN_NOEXCEPT;
    nn::Result DeleteAllPersonalizedTicket() NN_NOEXCEPT;
    nn::Result DeleteAllPersonalizedTicketExcludingList(const nn::sf::InArray<nn::es::TicketId>& ticketIdExclusionList) NN_NOEXCEPT;
    nn::Result CountCommonTicket(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
    nn::Result CountPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
    nn::Result ListCommonTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT;
    nn::Result ListPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT;
    nn::Result ListMissingPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::TicketId>& outTicketIdList, const nn::sf::InArray<nn::es::TicketId>& ticketIdList) NN_NOEXCEPT;
    nn::Result GetCommonTicketSize(nn::sf::Out<std::uint64_t> pOutSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
    nn::Result GetCommonTicketData(nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
    nn::Result OwnTicket(const nn::sf::OutArray<bool>& outOwnTicketList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT;
    nn::Result GetTicketInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::TicketInfo>& outTicketInfoList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT;
    nn::Result ListLightTicketInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::LightTicketInfo>& outTicketInfoList, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
    nn::Result SignData(nn::sf::Out<nn::es::Sign> pOutSign, nn::sf::Out<nn::es::Certificate> pOutCertificate, const nn::sf::InBuffer& pData) NN_NOEXCEPT;
    nn::Result GetCommonTicketAndCertificateSize(nn::sf::Out<std::uint64_t> pOutTicketSize, nn::sf::Out<std::uint64_t> pOutCertificateSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
    nn::Result GetCommonTicketAndCertificateData(nn::sf::Out<std::uint64_t> pOutTicketSize, nn::sf::Out<std::uint64_t> pOutCertificateSize, const nn::sf::OutBuffer& pOutTicketBuffer, const nn::sf::OutBuffer& pOutCertificateBuffer, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
    nn::Result ImportPrepurchaseRecord(const nn::es::PrepurchaseRecord& record) NN_NOEXCEPT;
    nn::Result DeletePrepurchaseRecord(const nn::es::PrepurchaseRecord& record) NN_NOEXCEPT;
    nn::Result DeleteAllPrepurchaseRecord() NN_NOEXCEPT;
    nn::Result CountPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
    nn::Result ListPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT;
    nn::Result ListPrepurchaseRecordInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::PrepurchaseRecord>& outPrepurchaseRecordList, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
    nn::Result CountDesignatedTicket(nn::sf::Out<std::int32_t> pOutCount, nn::es::RightsId rightsId) NN_NOEXCEPT;
    nn::Result ListDesignatedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList, nn::es::RightsId rightsId) NN_NOEXCEPT;
    nn::Result CountDesignatedPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, nn::es::RightsId rightsId) NN_NOEXCEPT;
    nn::Result ListDesignatedPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList, nn::es::RightsId rightsId) NN_NOEXCEPT;
    nn::Result GetEncryptedTicketSize(nn::sf::Out<std::uint64_t> pOutSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
    nn::Result GetEncryptedTicketData(nn::sf::Out<std::uint64_t> pOutTicketId, nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, const nn::sf::OutBuffer& pOutKey, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
    nn::Result CheckRightsStatusIncludingKeyId(const nn::sf::OutArray<nn::es::RightsStatus>& outStatusList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList, const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT;
    nn::Result CheckRightsStatus(const nn::sf::OutArray<nn::es::RightsStatus>& outStatusList, const nn::sf::InArray<nn::es::RightsId>& rightsIdList, const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT;
    nn::Result RegisterTitleKey(const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList, const nn::sf::InArray<std::int32_t>& keyGenerationList) NN_NOEXCEPT;
    nn::Result UnregisterAllTitleKey() NN_NOEXCEPT;
    nn::Result RegisterAccountRestrictedRightsUser(nn::es::ELicenseUserId userId) NN_NOEXCEPT;
    nn::Result UnregisterAllAccountRestrictedRightsUser() NN_NOEXCEPT;
    nn::Result ListAccountRestrictedRightsUser(nn::sf::Out<bool> outHasAccount, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseUserId>& outUserIdList) NN_NOEXCEPT;
    nn::Result BeginImportELicenseArchive(nn::sf::Out<nn::es::ELicenseImportContext> pOutContext, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
    nn::Result ImportELicenseArchive(const nn::es::ELicenseImportContext& context, const nn::sf::InBuffer& eLicenseArchive) NN_NOEXCEPT;
    nn::Result EndImportELicenseArchive(nn::sf::Out<nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const nn::es::ELicenseImportContext& context) NN_NOEXCEPT;
    nn::Result CountELicense(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
    nn::Result ListELicenseIds(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseId>& outELicenseIdList) NN_NOEXCEPT;
    nn::Result ListELicenseInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseInfoWrapper>& outELicenseInfoList, const nn::sf::InArray<nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT;
    nn::Result ListELicenseInfoForDebug(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseInfoForSystemWrapper>& outELicenseInfoList, const nn::sf::InArray<nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT;
    nn::Result EndImportELicenseArchiveForDebug(nn::sf::Out<nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const nn::es::ELicenseImportContext& context) NN_NOEXCEPT;
    nn::Result GetELicenseArchiveSizeForDebug(nn::sf::Out<std::uint64_t> pOutSize, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
    nn::Result GetELicenseArchiveDataForDebug(nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
    nn::Result DeleteAllELicenseArchiveForDebug() NN_NOEXCEPT;
    nn::Result GetChallengeOfLocalConcurrencyCheck(nn::sf::Out<nn::es::LocalConcurrencyCheckChallenge> outValue) NN_NOEXCEPT;
    nn::Result AuthorizeLocalConcurrencyCheckData(nn::sf::Out<nn::es::LocalConcurrencyCheckAuthenticationInfo> outInfo, const nn::sf::InArray<nn::es::LocalConcurrencyCheckData>& authenticatedDataList, const nn::es::LocalConcurrencyCheckData& unauthenticatedData) NN_NOEXCEPT;
    nn::Result GetLocalConcurrencyCheckData(nn::sf::Out<nn::es::LocalConcurrencyCheckData> outData, nn::es::LocalConcurrencyCheckChallenge challenge) NN_NOEXCEPT;
    nn::Result VerifyLocalConcurrencyAuthentication(const nn::es::LocalConcurrencyCheckAuthenticationInfo& info) NN_NOEXCEPT;
    nn::Result CreateActiveRightsContext(nn::sf::Out<nn::sf::SharedPointer<nn::es::IActiveRightsContext>> pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::es::IETicketService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportTicket, (const ::nn::sf::InBuffer& ticket, const ::nn::sf::InBuffer& certificate))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ImportTicket, (ticket, certificate));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportTicketCertificateSet, (const ::nn::sf::InBuffer& ticketCertificateSet))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ImportTicketCertificateSet, (ticketCertificateSet));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteTicket, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteTicket, (rightsIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeletePersonalizedTicket, (::nn::es::AccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeletePersonalizedTicket, (accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllCommonTicket)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteAllCommonTicket);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllPersonalizedTicket)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteAllPersonalizedTicket);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAllPersonalizedTicketExcludingList, (const ::nn::sf::InArray<::nn::es::TicketId>& ticketIdExclusionList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteAllPersonalizedTicketExcludingList, (ticketIdExclusionList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountCommonTicket, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountCommonTicket, (pOutCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountPersonalizedTicket, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountPersonalizedTicket, (pOutCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListCommonTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListCommonTicket, (pOutCount, outRightsIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListPersonalizedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListPersonalizedTicket, (pOutCount, outRightsIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListMissingPersonalizedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::TicketId>& outTicketIdList, const ::nn::sf::InArray<::nn::es::TicketId>& ticketIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListMissingPersonalizedTicket, (pOutCount, outTicketIdList, ticketIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketSize, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCommonTicketSize, (pOutSize, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketData, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCommonTicketData, (pOutSize, pOutBuffer, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OwnTicket, (const ::nn::sf::OutArray<bool>& outOwnTicketList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OwnTicket, (outOwnTicketList, rightsIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTicketInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::TicketInfo>& outTicketInfoList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTicketInfo, (pOutCount, outTicketInfoList, rightsIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLightTicketInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::LightTicketInfo>& outTicketInfoList, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListLightTicketInfo, (pOutCount, outTicketInfoList, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SignData, (::nn::sf::Out<::nn::es::Sign> pOutSign, ::nn::sf::Out<::nn::es::Certificate> pOutCertificate, const ::nn::sf::InBuffer& pData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SignData, (pOutSign, pOutCertificate, pData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketAndCertificateSize, (::nn::sf::Out<::std::uint64_t> pOutTicketSize, ::nn::sf::Out<::std::uint64_t> pOutCertificateSize, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCommonTicketAndCertificateSize, (pOutTicketSize, pOutCertificateSize, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketAndCertificateData, (::nn::sf::Out<::std::uint64_t> pOutTicketSize, ::nn::sf::Out<::std::uint64_t> pOutCertificateSize, const ::nn::sf::OutBuffer& pOutTicketBuffer, const ::nn::sf::OutBuffer& pOutCertificateBuffer, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCommonTicketAndCertificateData, (pOutTicketSize, pOutCertificateSize, pOutTicketBuffer, pOutCertificateBuffer, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportPrepurchaseRecord, (const ::nn::es::PrepurchaseRecord& record))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ImportPrepurchaseRecord, (record));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeletePrepurchaseRecord, (const ::nn::es::PrepurchaseRecord& record))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeletePrepurchaseRecord, (record));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllPrepurchaseRecord)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteAllPrepurchaseRecord);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountPrepurchaseRecord, (pOutCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListPrepurchaseRecord, (pOutCount, outRightsIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListPrepurchaseRecordInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::PrepurchaseRecord>& outPrepurchaseRecordList, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListPrepurchaseRecordInfo, (pOutCount, outPrepurchaseRecordList, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountDesignatedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, ::nn::es::RightsId rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountDesignatedTicket, (pOutCount, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDesignatedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList, ::nn::es::RightsId rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDesignatedTicket, (pOutCount, outRightsIdList, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountDesignatedPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount, ::nn::es::RightsId rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountDesignatedPrepurchaseRecord, (pOutCount, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDesignatedPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList, ::nn::es::RightsId rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDesignatedPrepurchaseRecord, (pOutCount, outRightsIdList, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEncryptedTicketSize, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetEncryptedTicketSize, (pOutSize, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEncryptedTicketData, (::nn::sf::Out<::std::uint64_t> pOutTicketId, ::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, const ::nn::sf::OutBuffer& pOutKey, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetEncryptedTicketData, (pOutTicketId, pOutSize, pOutBuffer, pOutKey, rightsId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckRightsStatusIncludingKeyId, (const ::nn::sf::OutArray<::nn::es::RightsStatus>& outStatusList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList, const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckRightsStatusIncludingKeyId, (outStatusList, rightsIdList, userIdList, onlyAllAccountRights));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckRightsStatus, (const ::nn::sf::OutArray<::nn::es::RightsStatus>& outStatusList, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIdList, const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckRightsStatus, (outStatusList, rightsIdList, userIdList, onlyAllAccountRights));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterTitleKey, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList, const ::nn::sf::InArray<::std::int32_t>& keyGenerationList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterTitleKey, (rightsIdList, keyGenerationList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllTitleKey)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnregisterAllTitleKey);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAccountRestrictedRightsUser, (::nn::es::ELicenseUserId userId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterAccountRestrictedRightsUser, (userId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllAccountRestrictedRightsUser)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnregisterAllAccountRestrictedRightsUser);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAccountRestrictedRightsUser, (::nn::sf::Out<bool> outHasAccount, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseUserId>& outUserIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAccountRestrictedRightsUser, (outHasAccount, outCount, outUserIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginImportELicenseArchive, (::nn::sf::Out<::nn::es::ELicenseImportContext> pOutContext, ::nn::es::ELicenseOwnerId ownerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BeginImportELicenseArchive, (pOutContext, ownerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportELicenseArchive, (const ::nn::es::ELicenseImportContext& context, const ::nn::sf::InBuffer& eLicenseArchive))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ImportELicenseArchive, (context, eLicenseArchive));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndImportELicenseArchive, (::nn::sf::Out<::nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const ::nn::es::ELicenseImportContext& context))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EndImportELicenseArchive, (pOutELicenseArchiveId, context));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountELicense, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountELicense, (pOutCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListELicenseIds, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseId>& outELicenseIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListELicenseIds, (pOutCount, outELicenseIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListELicenseInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseInfoWrapper>& outELicenseInfoList, const ::nn::sf::InArray<::nn::es::ELicenseId>& eLicenseIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListELicenseInfo, (pOutCount, outELicenseInfoList, eLicenseIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListELicenseInfoForDebug, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseInfoForSystemWrapper>& outELicenseInfoList, const ::nn::sf::InArray<::nn::es::ELicenseId>& eLicenseIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListELicenseInfoForDebug, (pOutCount, outELicenseInfoList, eLicenseIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndImportELicenseArchiveForDebug, (::nn::sf::Out<::nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const ::nn::es::ELicenseImportContext& context))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EndImportELicenseArchiveForDebug, (pOutELicenseArchiveId, context));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetELicenseArchiveSizeForDebug, (::nn::sf::Out<::std::uint64_t> pOutSize, ::nn::es::ELicenseOwnerId ownerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetELicenseArchiveSizeForDebug, (pOutSize, ownerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetELicenseArchiveDataForDebug, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, ::nn::es::ELicenseOwnerId ownerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetELicenseArchiveDataForDebug, (pOutSize, pOutBuffer, ownerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllELicenseArchiveForDebug)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteAllELicenseArchiveForDebug);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChallengeOfLocalConcurrencyCheck, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckChallenge> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetChallengeOfLocalConcurrencyCheck, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AuthorizeLocalConcurrencyCheckData, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckAuthenticationInfo> outInfo, const ::nn::sf::InArray<::nn::es::LocalConcurrencyCheckData>& authenticatedDataList, const ::nn::es::LocalConcurrencyCheckData& unauthenticatedData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AuthorizeLocalConcurrencyCheckData, (outInfo, authenticatedDataList, unauthenticatedData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalConcurrencyCheckData, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckData> outData, ::nn::es::LocalConcurrencyCheckChallenge challenge))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLocalConcurrencyCheckData, (outData, challenge));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyLocalConcurrencyAuthentication, (const ::nn::es::LocalConcurrencyCheckAuthenticationInfo& info))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(VerifyLocalConcurrencyAuthentication, (info));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateActiveRightsContext, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::es::IActiveRightsContext>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateActiveRightsContext, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::es::IETicketService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::es::IETicketService))

    // nn::Result ImportTicket(const nn::sf::InBuffer& ticket, const nn::sf::InBuffer& certificate) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ImportTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ticket, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(certificate, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (ticket, certificate))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ticket), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(certificate)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ImportTicket)

    // nn::Result ImportTicketCertificateSet(const nn::sf::InBuffer& ticketCertificateSet) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ImportTicketCertificateSet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ticketCertificateSet, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (ticketCertificateSet))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ticketCertificateSet)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ImportTicketCertificateSet)

    // nn::Result DeleteTicket(const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rightsIdList, 0, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (rightsIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteTicket)

    // nn::Result DeletePersonalizedTicket(nn::es::AccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeletePersonalizedTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::es::AccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeletePersonalizedTicket)

    // nn::Result DeleteAllCommonTicket() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteAllCommonTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteAllCommonTicket)

    // nn::Result DeleteAllPersonalizedTicket() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteAllPersonalizedTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteAllPersonalizedTicket)

    // nn::Result DeleteAllPersonalizedTicketExcludingList(const nn::sf::InArray<nn::es::TicketId>& ticketIdExclusionList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteAllPersonalizedTicketExcludingList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ticketIdExclusionList, 0, (const ::nn::sf::InArray<::nn::es::TicketId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (ticketIdExclusionList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ticketIdExclusionList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteAllPersonalizedTicketExcludingList)

    // nn::Result CountCommonTicket(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountCommonTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountCommonTicket)

    // nn::Result CountPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountPersonalizedTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountPersonalizedTicket)

    // nn::Result ListCommonTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListCommonTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outRightsIdList, 0, (const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outRightsIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRightsIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListCommonTicket)

    // nn::Result ListPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListPersonalizedTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outRightsIdList, 0, (const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outRightsIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRightsIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListPersonalizedTicket)

    // nn::Result ListMissingPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::TicketId>& outTicketIdList, const nn::sf::InArray<nn::es::TicketId>& ticketIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListMissingPersonalizedTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outTicketIdList, 0, (const ::nn::sf::OutArray<::nn::es::TicketId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ticketIdList, 1, (const ::nn::sf::InArray<::nn::es::TicketId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outTicketIdList, ticketIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTicketIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ticketIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListMissingPersonalizedTicket)

    // nn::Result GetCommonTicketSize(nn::sf::Out<std::uint64_t> pOutSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCommonTicketSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsIdIncludingKeyId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCommonTicketSize)

    // nn::Result GetCommonTicketData(nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCommonTicketData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsIdIncludingKeyId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCommonTicketData)

    // nn::Result OwnTicket(const nn::sf::OutArray<bool>& outOwnTicketList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OwnTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outOwnTicketList, 0, (const ::nn::sf::OutArray<bool>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rightsIdList, 1, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outOwnTicketList, rightsIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outOwnTicketList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OwnTicket)

    // nn::Result GetTicketInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::TicketInfo>& outTicketInfoList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTicketInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outTicketInfoList, 0, (const ::nn::sf::OutArray<::nn::es::TicketInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rightsIdList, 1, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outTicketInfoList, rightsIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTicketInfoList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTicketInfo)

    // nn::Result ListLightTicketInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::LightTicketInfo>& outTicketInfoList, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListLightTicketInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outTicketInfoList, 0, (const ::nn::sf::OutArray<::nn::es::LightTicketInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outTicketInfoList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsIdIncludingKeyId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTicketInfoList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListLightTicketInfo)

    // nn::Result SignData(nn::sf::Out<nn::es::Sign> pOutSign, nn::sf::Out<nn::es::Certificate> pOutCertificate, const nn::sf::InBuffer& pData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SignData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutSign, 0, (::nn::sf::Out<::nn::es::Sign>), 60, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutCertificate, 1, (::nn::sf::Out<::nn::es::Certificate>), 384, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pData, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (pOutSign, pOutCertificate, pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSign), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCertificate), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SignData)

    // nn::Result GetCommonTicketAndCertificateSize(nn::sf::Out<std::uint64_t> pOutTicketSize, nn::sf::Out<std::uint64_t> pOutCertificateSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCommonTicketAndCertificateSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsIdIncludingKeyId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutTicketSize, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCertificateSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutTicketSize, pOutCertificateSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutTicketSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCertificateSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCommonTicketAndCertificateSize)

    // nn::Result GetCommonTicketAndCertificateData(nn::sf::Out<std::uint64_t> pOutTicketSize, nn::sf::Out<std::uint64_t> pOutCertificateSize, const nn::sf::OutBuffer& pOutTicketBuffer, const nn::sf::OutBuffer& pOutCertificateBuffer, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCommonTicketAndCertificateData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutTicketBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutCertificateBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutTicketBuffer, pOutCertificateBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsIdIncludingKeyId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutTicketSize, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCertificateSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutTicketSize, pOutCertificateSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutTicketSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCertificateSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutTicketBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCertificateBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCommonTicketAndCertificateData)

    // nn::Result ImportPrepurchaseRecord(const nn::es::PrepurchaseRecord& record) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ImportPrepurchaseRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(record, 0, (const ::nn::es::PrepurchaseRecord&), 64, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (record))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(record)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ImportPrepurchaseRecord)

    // nn::Result DeletePrepurchaseRecord(const nn::es::PrepurchaseRecord& record) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeletePrepurchaseRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(record, 0, (const ::nn::es::PrepurchaseRecord&), 64, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (record))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(record)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeletePrepurchaseRecord)

    // nn::Result DeleteAllPrepurchaseRecord() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteAllPrepurchaseRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteAllPrepurchaseRecord)

    // nn::Result CountPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountPrepurchaseRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountPrepurchaseRecord)

    // nn::Result ListPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListPrepurchaseRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outRightsIdList, 0, (const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outRightsIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRightsIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListPrepurchaseRecord)

    // nn::Result ListPrepurchaseRecordInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::PrepurchaseRecord>& outPrepurchaseRecordList, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListPrepurchaseRecordInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outPrepurchaseRecordList, 0, (const ::nn::sf::OutArray<::nn::es::PrepurchaseRecord>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outPrepurchaseRecordList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsIdIncludingKeyId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPrepurchaseRecordList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListPrepurchaseRecordInfo)

    // nn::Result CountDesignatedTicket(nn::sf::Out<std::int32_t> pOutCount, nn::es::RightsId rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountDesignatedTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountDesignatedTicket)

    // nn::Result ListDesignatedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList, nn::es::RightsId rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDesignatedTicket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outRightsIdList, 0, (const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outRightsIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRightsIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDesignatedTicket)

    // nn::Result CountDesignatedPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, nn::es::RightsId rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountDesignatedPrepurchaseRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountDesignatedPrepurchaseRecord)

    // nn::Result ListDesignatedPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList, nn::es::RightsId rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDesignatedPrepurchaseRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outRightsIdList, 0, (const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outRightsIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRightsIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDesignatedPrepurchaseRecord)

    // nn::Result GetEncryptedTicketSize(nn::sf::Out<std::uint64_t> pOutSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetEncryptedTicketSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsIdIncludingKeyId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetEncryptedTicketSize)

    // nn::Result GetEncryptedTicketData(nn::sf::Out<std::uint64_t> pOutTicketId, nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, const nn::sf::OutBuffer& pOutKey, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetEncryptedTicketData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutKey, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutBuffer, pOutKey))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rightsId, (::nn::es::RightsIdIncludingKeyId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rightsId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutTicketId, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutTicketId, pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutTicketId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetEncryptedTicketData)

    // nn::Result CheckRightsStatusIncludingKeyId(const nn::sf::OutArray<nn::es::RightsStatus>& outStatusList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList, const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckRightsStatusIncludingKeyId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outStatusList, 0, (const ::nn::sf::OutArray<::nn::es::RightsStatus>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rightsIdList, 1, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(userIdList, 2, (const ::nn::sf::InArray<::nn::es::ELicenseUserId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (outStatusList, rightsIdList, userIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(onlyAllAccountRights, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (onlyAllAccountRights))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStatusList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(onlyAllAccountRights)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckRightsStatusIncludingKeyId)

    // nn::Result CheckRightsStatus(const nn::sf::OutArray<nn::es::RightsStatus>& outStatusList, const nn::sf::InArray<nn::es::RightsId>& rightsIdList, const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckRightsStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(502)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outStatusList, 0, (const ::nn::sf::OutArray<::nn::es::RightsStatus>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rightsIdList, 1, (const ::nn::sf::InArray<::nn::es::RightsId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(userIdList, 2, (const ::nn::sf::InArray<::nn::es::ELicenseUserId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (outStatusList, rightsIdList, userIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(onlyAllAccountRights, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (onlyAllAccountRights))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStatusList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(onlyAllAccountRights)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckRightsStatus)

    // nn::Result RegisterTitleKey(const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList, const nn::sf::InArray<std::int32_t>& keyGenerationList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterTitleKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(503)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rightsIdList, 0, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyGenerationList, 1, (const ::nn::sf::InArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (rightsIdList, keyGenerationList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyGenerationList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterTitleKey)

    // nn::Result UnregisterAllTitleKey() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterAllTitleKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(504)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterAllTitleKey)

    // nn::Result RegisterAccountRestrictedRightsUser(nn::es::ELicenseUserId userId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterAccountRestrictedRightsUser)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(506)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(userId, (::nn::es::ELicenseUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (userId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterAccountRestrictedRightsUser)

    // nn::Result UnregisterAllAccountRestrictedRightsUser() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterAllAccountRestrictedRightsUser)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(507)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterAllAccountRestrictedRightsUser)

    // nn::Result ListAccountRestrictedRightsUser(nn::sf::Out<bool> outHasAccount, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseUserId>& outUserIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAccountRestrictedRightsUser)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(508)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outUserIdList, 0, (const ::nn::sf::OutArray<::nn::es::ELicenseUserId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outUserIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHasAccount, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outHasAccount, outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHasAccount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUserIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAccountRestrictedRightsUser)

    // nn::Result BeginImportELicenseArchive(nn::sf::Out<nn::es::ELicenseImportContext> pOutContext, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BeginImportELicenseArchive)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ownerId, (::nn::es::ELicenseOwnerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (ownerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutContext, (::nn::es::ELicenseImportContext), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutContext))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ownerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BeginImportELicenseArchive)

    // nn::Result ImportELicenseArchive(const nn::es::ELicenseImportContext& context, const nn::sf::InBuffer& eLicenseArchive) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ImportELicenseArchive)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(eLicenseArchive, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (eLicenseArchive))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(context, (::nn::es::ELicenseImportContext), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (context))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(context), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eLicenseArchive)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ImportELicenseArchive)

    // nn::Result EndImportELicenseArchive(nn::sf::Out<nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const nn::es::ELicenseImportContext& context) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EndImportELicenseArchive)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(context, (::nn::es::ELicenseImportContext), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (context))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutELicenseArchiveId, (::nn::es::ELicenseArchiveId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutELicenseArchiveId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutELicenseArchiveId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(context)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EndImportELicenseArchive)

    // nn::Result CountELicense(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountELicense)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountELicense)

    // nn::Result ListELicenseIds(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseId>& outELicenseIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListELicenseIds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1005)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outELicenseIdList, 0, (const ::nn::sf::OutArray<::nn::es::ELicenseId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outELicenseIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outELicenseIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListELicenseIds)

    // nn::Result ListELicenseInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseInfoWrapper>& outELicenseInfoList, const nn::sf::InArray<nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListELicenseInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1006)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outELicenseInfoList, 0, (const ::nn::sf::OutArray<::nn::es::ELicenseInfoWrapper>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(eLicenseIdList, 1, (const ::nn::sf::InArray<::nn::es::ELicenseId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outELicenseInfoList, eLicenseIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outELicenseInfoList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eLicenseIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListELicenseInfo)

    // nn::Result ListELicenseInfoForDebug(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseInfoForSystemWrapper>& outELicenseInfoList, const nn::sf::InArray<nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListELicenseInfoForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1007)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outELicenseInfoList, 0, (const ::nn::sf::OutArray<::nn::es::ELicenseInfoForSystemWrapper>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(eLicenseIdList, 1, (const ::nn::sf::InArray<::nn::es::ELicenseId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outELicenseInfoList, eLicenseIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outELicenseInfoList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eLicenseIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListELicenseInfoForDebug)

    // nn::Result EndImportELicenseArchiveForDebug(nn::sf::Out<nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const nn::es::ELicenseImportContext& context) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EndImportELicenseArchiveForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1008)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(context, (::nn::es::ELicenseImportContext), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (context))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutELicenseArchiveId, (::nn::es::ELicenseArchiveId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutELicenseArchiveId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutELicenseArchiveId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(context)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EndImportELicenseArchiveForDebug)

    // nn::Result GetELicenseArchiveSizeForDebug(nn::sf::Out<std::uint64_t> pOutSize, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetELicenseArchiveSizeForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1009)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ownerId, (::nn::es::ELicenseOwnerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (ownerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ownerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetELicenseArchiveSizeForDebug)

    // nn::Result GetELicenseArchiveDataForDebug(nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetELicenseArchiveDataForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ownerId, (::nn::es::ELicenseOwnerId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (ownerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ownerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetELicenseArchiveDataForDebug)

    // nn::Result DeleteAllELicenseArchiveForDebug() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteAllELicenseArchiveForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteAllELicenseArchiveForDebug)

    // nn::Result GetChallengeOfLocalConcurrencyCheck(nn::sf::Out<nn::es::LocalConcurrencyCheckChallenge> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetChallengeOfLocalConcurrencyCheck)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::es::LocalConcurrencyCheckChallenge), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetChallengeOfLocalConcurrencyCheck)

    // nn::Result AuthorizeLocalConcurrencyCheckData(nn::sf::Out<nn::es::LocalConcurrencyCheckAuthenticationInfo> outInfo, const nn::sf::InArray<nn::es::LocalConcurrencyCheckData>& authenticatedDataList, const nn::es::LocalConcurrencyCheckData& unauthenticatedData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AuthorizeLocalConcurrencyCheckData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1502)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outInfo, 0, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckAuthenticationInfo>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(unauthenticatedData, 1, (const ::nn::es::LocalConcurrencyCheckData&), 768, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(authenticatedDataList, 2, (const ::nn::sf::InArray<::nn::es::LocalConcurrencyCheckData>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (outInfo, unauthenticatedData, authenticatedDataList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(authenticatedDataList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(unauthenticatedData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AuthorizeLocalConcurrencyCheckData)

    // nn::Result GetLocalConcurrencyCheckData(nn::sf::Out<nn::es::LocalConcurrencyCheckData> outData, nn::es::LocalConcurrencyCheckChallenge challenge) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLocalConcurrencyCheckData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1503)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outData, 0, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckData>), 768, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(challenge, (::nn::es::LocalConcurrencyCheckChallenge), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (challenge))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(challenge)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLocalConcurrencyCheckData)

    // nn::Result VerifyLocalConcurrencyAuthentication(const nn::es::LocalConcurrencyCheckAuthenticationInfo& info) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(VerifyLocalConcurrencyAuthentication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1504)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(info, 0, (const ::nn::es::LocalConcurrencyCheckAuthenticationInfo&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (info))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(VerifyLocalConcurrencyAuthentication)

    // nn::Result CreateActiveRightsContext(nn::sf::Out<nn::sf::SharedPointer<nn::es::IActiveRightsContext>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateActiveRightsContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateActiveRightsContext)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::RightsIdIncludingKeyId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::AccountId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::TicketId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::TicketInfo), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::LightTicketInfo), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::Sign), 60, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::Certificate), 384, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::PrepurchaseRecord), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::RightsId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::RightsStatus), 56, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseImportContext), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseOwnerId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseArchiveId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseInfoWrapper), 72, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseInfoForSystemWrapper), 80, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::LocalConcurrencyCheckChallenge), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::LocalConcurrencyCheckAuthenticationInfo), 256, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::LocalConcurrencyCheckData), 768, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::es::IETicketService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::es::IETicketService))

    // nn::Result ImportTicket(const nn::sf::InBuffer& ticket, const nn::sf::InBuffer& certificate) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportTicket, (const ::nn::sf::InBuffer& ticket, const ::nn::sf::InBuffer& certificate))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ImportTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ticket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(certificate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ImportTicket)
    }

    // nn::Result ImportTicketCertificateSet(const nn::sf::InBuffer& ticketCertificateSet) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportTicketCertificateSet, (const ::nn::sf::InBuffer& ticketCertificateSet))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ImportTicketCertificateSet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ticketCertificateSet)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ImportTicketCertificateSet)
    }

    // nn::Result DeleteTicket(const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteTicket, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteTicket)
    }

    // nn::Result DeletePersonalizedTicket(nn::es::AccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeletePersonalizedTicket, (::nn::es::AccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeletePersonalizedTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeletePersonalizedTicket)
    }

    // nn::Result DeleteAllCommonTicket() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllCommonTicket)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteAllCommonTicket)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteAllCommonTicket)
    }

    // nn::Result DeleteAllPersonalizedTicket() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllPersonalizedTicket)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteAllPersonalizedTicket)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteAllPersonalizedTicket)
    }

    // nn::Result DeleteAllPersonalizedTicketExcludingList(const nn::sf::InArray<nn::es::TicketId>& ticketIdExclusionList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAllPersonalizedTicketExcludingList, (const ::nn::sf::InArray<::nn::es::TicketId>& ticketIdExclusionList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteAllPersonalizedTicketExcludingList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ticketIdExclusionList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteAllPersonalizedTicketExcludingList)
    }

    // nn::Result CountCommonTicket(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountCommonTicket, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountCommonTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountCommonTicket)
    }

    // nn::Result CountPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountPersonalizedTicket, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountPersonalizedTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountPersonalizedTicket)
    }

    // nn::Result ListCommonTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListCommonTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListCommonTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRightsIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListCommonTicket)
    }

    // nn::Result ListPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListPersonalizedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListPersonalizedTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRightsIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListPersonalizedTicket)
    }

    // nn::Result ListMissingPersonalizedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::TicketId>& outTicketIdList, const nn::sf::InArray<nn::es::TicketId>& ticketIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListMissingPersonalizedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::TicketId>& outTicketIdList, const ::nn::sf::InArray<::nn::es::TicketId>& ticketIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListMissingPersonalizedTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTicketIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ticketIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListMissingPersonalizedTicket)
    }

    // nn::Result GetCommonTicketSize(nn::sf::Out<std::uint64_t> pOutSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketSize, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCommonTicketSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCommonTicketSize)
    }

    // nn::Result GetCommonTicketData(nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketData, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCommonTicketData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCommonTicketData)
    }

    // nn::Result OwnTicket(const nn::sf::OutArray<bool>& outOwnTicketList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OwnTicket, (const ::nn::sf::OutArray<bool>& outOwnTicketList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OwnTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outOwnTicketList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OwnTicket)
    }

    // nn::Result GetTicketInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::TicketInfo>& outTicketInfoList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTicketInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::TicketInfo>& outTicketInfoList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTicketInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTicketInfoList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTicketInfo)
    }

    // nn::Result ListLightTicketInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::LightTicketInfo>& outTicketInfoList, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLightTicketInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::LightTicketInfo>& outTicketInfoList, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListLightTicketInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTicketInfoList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListLightTicketInfo)
    }

    // nn::Result SignData(nn::sf::Out<nn::es::Sign> pOutSign, nn::sf::Out<nn::es::Certificate> pOutCertificate, const nn::sf::InBuffer& pData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SignData, (::nn::sf::Out<::nn::es::Sign> pOutSign, ::nn::sf::Out<::nn::es::Certificate> pOutCertificate, const ::nn::sf::InBuffer& pData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SignData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSign)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCertificate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SignData)
    }

    // nn::Result GetCommonTicketAndCertificateSize(nn::sf::Out<std::uint64_t> pOutTicketSize, nn::sf::Out<std::uint64_t> pOutCertificateSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketAndCertificateSize, (::nn::sf::Out<::std::uint64_t> pOutTicketSize, ::nn::sf::Out<::std::uint64_t> pOutCertificateSize, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCommonTicketAndCertificateSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutTicketSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCertificateSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCommonTicketAndCertificateSize)
    }

    // nn::Result GetCommonTicketAndCertificateData(nn::sf::Out<std::uint64_t> pOutTicketSize, nn::sf::Out<std::uint64_t> pOutCertificateSize, const nn::sf::OutBuffer& pOutTicketBuffer, const nn::sf::OutBuffer& pOutCertificateBuffer, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCommonTicketAndCertificateData, (::nn::sf::Out<::std::uint64_t> pOutTicketSize, ::nn::sf::Out<::std::uint64_t> pOutCertificateSize, const ::nn::sf::OutBuffer& pOutTicketBuffer, const ::nn::sf::OutBuffer& pOutCertificateBuffer, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCommonTicketAndCertificateData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutTicketSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCertificateSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutTicketBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCertificateBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCommonTicketAndCertificateData)
    }

    // nn::Result ImportPrepurchaseRecord(const nn::es::PrepurchaseRecord& record) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportPrepurchaseRecord, (const ::nn::es::PrepurchaseRecord& record))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ImportPrepurchaseRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(record)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ImportPrepurchaseRecord)
    }

    // nn::Result DeletePrepurchaseRecord(const nn::es::PrepurchaseRecord& record) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeletePrepurchaseRecord, (const ::nn::es::PrepurchaseRecord& record))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeletePrepurchaseRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(record)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeletePrepurchaseRecord)
    }

    // nn::Result DeleteAllPrepurchaseRecord() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllPrepurchaseRecord)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteAllPrepurchaseRecord)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteAllPrepurchaseRecord)
    }

    // nn::Result CountPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountPrepurchaseRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountPrepurchaseRecord)
    }

    // nn::Result ListPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListPrepurchaseRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRightsIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListPrepurchaseRecord)
    }

    // nn::Result ListPrepurchaseRecordInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::PrepurchaseRecord>& outPrepurchaseRecordList, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListPrepurchaseRecordInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::PrepurchaseRecord>& outPrepurchaseRecordList, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListPrepurchaseRecordInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPrepurchaseRecordList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListPrepurchaseRecordInfo)
    }

    // nn::Result CountDesignatedTicket(nn::sf::Out<std::int32_t> pOutCount, nn::es::RightsId rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountDesignatedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, ::nn::es::RightsId rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountDesignatedTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountDesignatedTicket)
    }

    // nn::Result ListDesignatedTicket(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList, nn::es::RightsId rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDesignatedTicket, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList, ::nn::es::RightsId rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDesignatedTicket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRightsIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDesignatedTicket)
    }

    // nn::Result CountDesignatedPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, nn::es::RightsId rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountDesignatedPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount, ::nn::es::RightsId rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountDesignatedPrepurchaseRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountDesignatedPrepurchaseRecord)
    }

    // nn::Result ListDesignatedPrepurchaseRecord(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::RightsIdIncludingKeyId>& outRightsIdList, nn::es::RightsId rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDesignatedPrepurchaseRecord, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::RightsIdIncludingKeyId>& outRightsIdList, ::nn::es::RightsId rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDesignatedPrepurchaseRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRightsIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDesignatedPrepurchaseRecord)
    }

    // nn::Result GetEncryptedTicketSize(nn::sf::Out<std::uint64_t> pOutSize, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEncryptedTicketSize, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetEncryptedTicketSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetEncryptedTicketSize)
    }

    // nn::Result GetEncryptedTicketData(nn::sf::Out<std::uint64_t> pOutTicketId, nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, const nn::sf::OutBuffer& pOutKey, const nn::es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEncryptedTicketData, (::nn::sf::Out<::std::uint64_t> pOutTicketId, ::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, const ::nn::sf::OutBuffer& pOutKey, const ::nn::es::RightsIdIncludingKeyId& rightsId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetEncryptedTicketData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutTicketId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetEncryptedTicketData)
    }

    // nn::Result CheckRightsStatusIncludingKeyId(const nn::sf::OutArray<nn::es::RightsStatus>& outStatusList, const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList, const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckRightsStatusIncludingKeyId, (const ::nn::sf::OutArray<::nn::es::RightsStatus>& outStatusList, const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList, const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckRightsStatusIncludingKeyId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStatusList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(onlyAllAccountRights)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckRightsStatusIncludingKeyId)
    }

    // nn::Result CheckRightsStatus(const nn::sf::OutArray<nn::es::RightsStatus>& outStatusList, const nn::sf::InArray<nn::es::RightsId>& rightsIdList, const nn::sf::InArray<nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckRightsStatus, (const ::nn::sf::OutArray<::nn::es::RightsStatus>& outStatusList, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIdList, const ::nn::sf::InArray<::nn::es::ELicenseUserId>& userIdList, bool onlyAllAccountRights))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckRightsStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStatusList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(onlyAllAccountRights)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckRightsStatus)
    }

    // nn::Result RegisterTitleKey(const nn::sf::InArray<nn::es::RightsIdIncludingKeyId>& rightsIdList, const nn::sf::InArray<std::int32_t>& keyGenerationList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterTitleKey, (const ::nn::sf::InArray<::nn::es::RightsIdIncludingKeyId>& rightsIdList, const ::nn::sf::InArray<::std::int32_t>& keyGenerationList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterTitleKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyGenerationList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterTitleKey)
    }

    // nn::Result UnregisterAllTitleKey() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllTitleKey)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterAllTitleKey)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterAllTitleKey)
    }

    // nn::Result RegisterAccountRestrictedRightsUser(nn::es::ELicenseUserId userId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAccountRestrictedRightsUser, (::nn::es::ELicenseUserId userId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterAccountRestrictedRightsUser)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterAccountRestrictedRightsUser)
    }

    // nn::Result UnregisterAllAccountRestrictedRightsUser() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllAccountRestrictedRightsUser)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterAllAccountRestrictedRightsUser)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterAllAccountRestrictedRightsUser)
    }

    // nn::Result ListAccountRestrictedRightsUser(nn::sf::Out<bool> outHasAccount, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::es::ELicenseUserId>& outUserIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAccountRestrictedRightsUser, (::nn::sf::Out<bool> outHasAccount, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::es::ELicenseUserId>& outUserIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAccountRestrictedRightsUser)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHasAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUserIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAccountRestrictedRightsUser)
    }

    // nn::Result BeginImportELicenseArchive(nn::sf::Out<nn::es::ELicenseImportContext> pOutContext, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginImportELicenseArchive, (::nn::sf::Out<::nn::es::ELicenseImportContext> pOutContext, ::nn::es::ELicenseOwnerId ownerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BeginImportELicenseArchive)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ownerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BeginImportELicenseArchive)
    }

    // nn::Result ImportELicenseArchive(const nn::es::ELicenseImportContext& context, const nn::sf::InBuffer& eLicenseArchive) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportELicenseArchive, (const ::nn::es::ELicenseImportContext& context, const ::nn::sf::InBuffer& eLicenseArchive))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ImportELicenseArchive)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(context)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eLicenseArchive)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ImportELicenseArchive)
    }

    // nn::Result EndImportELicenseArchive(nn::sf::Out<nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const nn::es::ELicenseImportContext& context) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndImportELicenseArchive, (::nn::sf::Out<::nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const ::nn::es::ELicenseImportContext& context))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EndImportELicenseArchive)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutELicenseArchiveId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(context)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EndImportELicenseArchive)
    }

    // nn::Result CountELicense(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountELicense, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountELicense)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountELicense)
    }

    // nn::Result ListELicenseIds(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseId>& outELicenseIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListELicenseIds, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseId>& outELicenseIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListELicenseIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outELicenseIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListELicenseIds)
    }

    // nn::Result ListELicenseInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseInfoWrapper>& outELicenseInfoList, const nn::sf::InArray<nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListELicenseInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseInfoWrapper>& outELicenseInfoList, const ::nn::sf::InArray<::nn::es::ELicenseId>& eLicenseIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListELicenseInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outELicenseInfoList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eLicenseIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListELicenseInfo)
    }

    // nn::Result ListELicenseInfoForDebug(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::es::ELicenseInfoForSystemWrapper>& outELicenseInfoList, const nn::sf::InArray<nn::es::ELicenseId>& eLicenseIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListELicenseInfoForDebug, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::es::ELicenseInfoForSystemWrapper>& outELicenseInfoList, const ::nn::sf::InArray<::nn::es::ELicenseId>& eLicenseIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListELicenseInfoForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outELicenseInfoList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eLicenseIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListELicenseInfoForDebug)
    }

    // nn::Result EndImportELicenseArchiveForDebug(nn::sf::Out<nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const nn::es::ELicenseImportContext& context) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndImportELicenseArchiveForDebug, (::nn::sf::Out<::nn::es::ELicenseArchiveId> pOutELicenseArchiveId, const ::nn::es::ELicenseImportContext& context))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EndImportELicenseArchiveForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutELicenseArchiveId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(context)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EndImportELicenseArchiveForDebug)
    }

    // nn::Result GetELicenseArchiveSizeForDebug(nn::sf::Out<std::uint64_t> pOutSize, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetELicenseArchiveSizeForDebug, (::nn::sf::Out<::std::uint64_t> pOutSize, ::nn::es::ELicenseOwnerId ownerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetELicenseArchiveSizeForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ownerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetELicenseArchiveSizeForDebug)
    }

    // nn::Result GetELicenseArchiveDataForDebug(nn::sf::Out<std::uint64_t> pOutSize, const nn::sf::OutBuffer& pOutBuffer, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetELicenseArchiveDataForDebug, (::nn::sf::Out<::std::uint64_t> pOutSize, const ::nn::sf::OutBuffer& pOutBuffer, ::nn::es::ELicenseOwnerId ownerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetELicenseArchiveDataForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ownerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetELicenseArchiveDataForDebug)
    }

    // nn::Result DeleteAllELicenseArchiveForDebug() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteAllELicenseArchiveForDebug)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteAllELicenseArchiveForDebug)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteAllELicenseArchiveForDebug)
    }

    // nn::Result GetChallengeOfLocalConcurrencyCheck(nn::sf::Out<nn::es::LocalConcurrencyCheckChallenge> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChallengeOfLocalConcurrencyCheck, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckChallenge> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetChallengeOfLocalConcurrencyCheck)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetChallengeOfLocalConcurrencyCheck)
    }

    // nn::Result AuthorizeLocalConcurrencyCheckData(nn::sf::Out<nn::es::LocalConcurrencyCheckAuthenticationInfo> outInfo, const nn::sf::InArray<nn::es::LocalConcurrencyCheckData>& authenticatedDataList, const nn::es::LocalConcurrencyCheckData& unauthenticatedData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AuthorizeLocalConcurrencyCheckData, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckAuthenticationInfo> outInfo, const ::nn::sf::InArray<::nn::es::LocalConcurrencyCheckData>& authenticatedDataList, const ::nn::es::LocalConcurrencyCheckData& unauthenticatedData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AuthorizeLocalConcurrencyCheckData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(authenticatedDataList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(unauthenticatedData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AuthorizeLocalConcurrencyCheckData)
    }

    // nn::Result GetLocalConcurrencyCheckData(nn::sf::Out<nn::es::LocalConcurrencyCheckData> outData, nn::es::LocalConcurrencyCheckChallenge challenge) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalConcurrencyCheckData, (::nn::sf::Out<::nn::es::LocalConcurrencyCheckData> outData, ::nn::es::LocalConcurrencyCheckChallenge challenge))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLocalConcurrencyCheckData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(challenge)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLocalConcurrencyCheckData)
    }

    // nn::Result VerifyLocalConcurrencyAuthentication(const nn::es::LocalConcurrencyCheckAuthenticationInfo& info) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyLocalConcurrencyAuthentication, (const ::nn::es::LocalConcurrencyCheckAuthenticationInfo& info))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(VerifyLocalConcurrencyAuthentication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(VerifyLocalConcurrencyAuthentication)
    }

    // nn::Result CreateActiveRightsContext(nn::sf::Out<nn::sf::SharedPointer<nn::es::IActiveRightsContext>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateActiveRightsContext, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::es::IActiveRightsContext>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateActiveRightsContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateActiveRightsContext)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::es::IETicketService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::es::IETicketService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ImportTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ticket)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(certificate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ImportTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ticket),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(certificate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ImportTicketCertificateSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ticketCertificateSet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ImportTicketCertificateSet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ticketCertificateSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rightsIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeletePersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeletePersonalizedTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteAllCommonTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteAllCommonTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteAllPersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteAllPersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteAllPersonalizedTicketExcludingList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ticketIdExclusionList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteAllPersonalizedTicketExcludingList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ticketIdExclusionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountCommonTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountCommonTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountPersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountPersonalizedTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListCommonTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outRightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListCommonTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outRightsIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListPersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outRightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListPersonalizedTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outRightsIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListMissingPersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outTicketIdList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ticketIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListMissingPersonalizedTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outTicketIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ticketIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCommonTicketSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCommonTicketSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCommonTicketData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCommonTicketData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OwnTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outOwnTicketList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OwnTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outOwnTicketList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rightsIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTicketInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outTicketInfoList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTicketInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outTicketInfoList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rightsIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListLightTicketInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outTicketInfoList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListLightTicketInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outTicketInfoList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SignData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutSign)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutCertificate)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SignData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutSign),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutCertificate),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCommonTicketAndCertificateSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCommonTicketAndCertificateSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutTicketSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCertificateSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCommonTicketAndCertificateData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutTicketBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutCertificateBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCommonTicketAndCertificateData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutTicketSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCertificateSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutTicketBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutCertificateBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ImportPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(record)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ImportPrepurchaseRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(record)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeletePrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(record)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeletePrepurchaseRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(record)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteAllPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteAllPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountPrepurchaseRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outRightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListPrepurchaseRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outRightsIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListPrepurchaseRecordInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outPrepurchaseRecordList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListPrepurchaseRecordInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outPrepurchaseRecordList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountDesignatedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountDesignatedTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDesignatedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outRightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDesignatedTicket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outRightsIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountDesignatedPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountDesignatedPrepurchaseRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDesignatedPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outRightsIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDesignatedPrepurchaseRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outRightsIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetEncryptedTicketSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetEncryptedTicketSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetEncryptedTicketData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetEncryptedTicketData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutTicketId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rightsId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckRightsStatusIncludingKeyId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outStatusList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rightsIdList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckRightsStatusIncludingKeyId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outStatusList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rightsIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(onlyAllAccountRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckRightsStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outStatusList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rightsIdList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckRightsStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outStatusList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rightsIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(onlyAllAccountRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterTitleKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rightsIdList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyGenerationList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterTitleKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rightsIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyGenerationList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterAllTitleKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterAllTitleKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterAccountRestrictedRightsUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterAccountRestrictedRightsUser)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(userId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterAllAccountRestrictedRightsUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterAllAccountRestrictedRightsUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAccountRestrictedRightsUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUserIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAccountRestrictedRightsUser)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHasAccount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUserIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BeginImportELicenseArchive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BeginImportELicenseArchive)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ownerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ImportELicenseArchive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(eLicenseArchive)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ImportELicenseArchive)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(context),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(eLicenseArchive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EndImportELicenseArchive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EndImportELicenseArchive)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutELicenseArchiveId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(context)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountELicense)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountELicense)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListELicenseIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outELicenseIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListELicenseIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outELicenseIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListELicenseInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outELicenseInfoList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(eLicenseIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListELicenseInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outELicenseInfoList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(eLicenseIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListELicenseInfoForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outELicenseInfoList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(eLicenseIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListELicenseInfoForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outELicenseInfoList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(eLicenseIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EndImportELicenseArchiveForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EndImportELicenseArchiveForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutELicenseArchiveId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(context)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetELicenseArchiveSizeForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetELicenseArchiveSizeForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ownerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetELicenseArchiveDataForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetELicenseArchiveDataForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ownerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteAllELicenseArchiveForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteAllELicenseArchiveForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetChallengeOfLocalConcurrencyCheck)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetChallengeOfLocalConcurrencyCheck)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AuthorizeLocalConcurrencyCheckData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(unauthenticatedData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(authenticatedDataList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AuthorizeLocalConcurrencyCheckData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(authenticatedDataList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(unauthenticatedData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLocalConcurrencyCheckData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLocalConcurrencyCheckData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(challenge)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(VerifyLocalConcurrencyAuthentication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(info)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(VerifyLocalConcurrencyAuthentication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(info)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateActiveRightsContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::es::IActiveRightsContext>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateActiveRightsContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ImportTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ImportTicketCertificateSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeletePersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteAllCommonTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteAllPersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteAllPersonalizedTicketExcludingList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountCommonTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountPersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListCommonTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListPersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListMissingPersonalizedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCommonTicketSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCommonTicketData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OwnTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTicketInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListLightTicketInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SignData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCommonTicketAndCertificateSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCommonTicketAndCertificateData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ImportPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeletePrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteAllPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListPrepurchaseRecordInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountDesignatedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDesignatedTicket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountDesignatedPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDesignatedPrepurchaseRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetEncryptedTicketSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetEncryptedTicketData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckRightsStatusIncludingKeyId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckRightsStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterTitleKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterAllTitleKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterAccountRestrictedRightsUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterAllAccountRestrictedRightsUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAccountRestrictedRightsUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BeginImportELicenseArchive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ImportELicenseArchive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EndImportELicenseArchive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountELicense)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListELicenseIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListELicenseInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListELicenseInfoForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EndImportELicenseArchiveForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetELicenseArchiveSizeForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetELicenseArchiveDataForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteAllELicenseArchiveForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetChallengeOfLocalConcurrencyCheck)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AuthorizeLocalConcurrencyCheckData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLocalConcurrencyCheckData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(VerifyLocalConcurrencyAuthentication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateActiveRightsContext)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::es::IETicketService))
