﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

 /**
 *   @file
 *   @brief  eLicense アーカイブに関するデバッグ用 API
 *           製品ではこのファイルの API は利用しません。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/es/es_Types.h>
#include <nn/es/es_ELicenseTypes.h>
#include "../../../Programs/Eris/Sources/Libraries/es/es_Json.h"

namespace nn { namespace es { namespace debug {

struct ELicenseArchiveInfoForDebug
{
    uint64_t                    challenge;
    ELicenseArchiveId           archiveId;
    time::PosixTime             publishDate;
    account::NintendoAccountId  ownerNaId;
};

struct ELicenseInfoForDebug
{
    ELicenseId                  id;
    RightsId                    rightsId;
    TicketId                    ticketId;
    account::NintendoAccountId  ticketOwnerNaId;
    ExpireDate                  expireDate;
    AccountId                   ticketOwnerVaId;
    ELicenseScope               scope;
    bool                        availableAfterReboot;
    bool                        recommendsServerInteraction;
};

ELicenseArchiveInfoForDebug MakeELicenseArchiveInfo(uint64_t challenge, account::NintendoAccountId ownerNaId) NN_NOEXCEPT;
ELicenseArchiveInfoForDebug MakeELicenseArchiveInfo(uint64_t challenge, account::NintendoAccountId ownerNaId, ELicenseArchiveId archiveId) NN_NOEXCEPT;

ELicenseInfoForDebug MakeDeviceLinkedPermanentELicense(RightsId rightsId, account::NintendoAccountId ticketOwnerNaId, TicketId ticketId, AccountId ticketOwnerVaId) NN_NOEXCEPT;
ELicenseInfoForDebug MakeDeviceLinkedPermanentELicense(RightsId rightsId, account::NintendoAccountId ticketOwnerNaId, TicketId ticketId, AccountId ticketOwnerVaId, ELicenseId eLicenseId) NN_NOEXCEPT;
bool MakeDeviceLinkedPermanentELicenseFromTicketDBInfo(ELicenseInfoForDebug* outValue, RightsId rightsId, account::NintendoAccountId ticketOwnerNaId) NN_NOEXCEPT;
bool MakeDeviceLinkedPermanentELicenseFromTicketDBInfo(ELicenseInfoForDebug* outValue, RightsId rightsId, account::NintendoAccountId ticketOwnerNaId, ELicenseId eLicenseId) NN_NOEXCEPT;

ELicenseInfoForDebug MakeAccountRestrictiveTemporaryELicense(RightsId rightsId, account::NintendoAccountId ticketOwnerNaId, TicketId ticketId, AccountId ticketOwnerVaId) NN_NOEXCEPT;
ELicenseInfoForDebug MakeAccountRestrictiveTemporaryELicense(RightsId rightsId, account::NintendoAccountId ticketOwnerNaId, TicketId ticketId, AccountId ticketOwnerVaId, ELicenseId eLicenseId) NN_NOEXCEPT;
bool MakeAccountRestrictiveTemporaryELicenseFromTicketDBInfo(ELicenseInfoForDebug* outValue, RightsId rightsId, account::NintendoAccountId ticketOwnerNaId) NN_NOEXCEPT;
bool MakeAccountRestrictiveTemporaryELicenseFromTicketDBInfo(ELicenseInfoForDebug* outValue, RightsId rightsId, account::NintendoAccountId ticketOwnerNaId, ELicenseId eLicenseId) NN_NOEXCEPT;
bool MakeAccountRestrictiveTemporaryELicenseFromTicketDBInfo(ELicenseInfoForDebug* outValue, RightsId rightsId, account::NintendoAccountId ticketOwnerNaId, TimeSpan expireSpan) NN_NOEXCEPT;

size_t BuildELicenseArchiveJsonString(char* outBuffer, size_t bufferSize, const ELicenseArchiveInfoForDebug& info, const ELicenseInfoForDebug* pList, int listCount) NN_NOEXCEPT;

/**
*   @brief      デバッグ用に eLicense アーカイブ Json を読み込むクラスです。
*               Json を DOM でパースするため、システムプロセスからは利用しないでください。
*/
class ELicenseArchiveJsonReader
{
public:
    void Initialize(const char* string) NN_NOEXCEPT;

    ELicenseInfoForDebug operator[](int index) const NN_NOEXCEPT
    {
        return GetELicense(index);
    }

    ELicenseArchiveInfoForDebug GetELicenseArchiveInfo() const NN_NOEXCEPT;
    int CountELicense() const NN_NOEXCEPT;
    ELicenseInfoForDebug GetELicense(int index) const NN_NOEXCEPT;

private:
    nne::rapidjson::Document m_Document;
};

}}}
