﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/err/err_Types.h>
#include <nn/nn_Result.h>

namespace nn { namespace err { namespace detail {
    namespace {
        // NXのシステムのエラーコードは 2XXX-YYYY という形式。nn::Result 系は (module 値 + 2000) がエラーコードのカテゴリに対応する。
        const int ErrorCodeCategoryPlatformPrefixForResultModule = 2000;

        NN_FORCEINLINE ErrorCode ConvertResultToErrorCode(const nn::Result& result) NN_NOEXCEPT
        {
            ErrorCode errorCode = {
                static_cast<ErrorCodeCategory>(result.GetModule() + ErrorCodeCategoryPlatformPrefixForResultModule),
                static_cast<ErrorCodeNumber>(result.GetDescription())
            };
            return errorCode;
        }

        NN_FORCEINLINE nn::Result ConvertErrorCodeToResult(const ErrorCode& errorCode) NN_NOEXCEPT
        {
            auto innerValue = nn::result::detail::ResultTraits::MakeInnerValue(
                errorCode.category - ErrorCodeCategoryPlatformPrefixForResultModule,
                errorCode.number
            );
            return nn::result::detail::ConstructResult(innerValue);
        }

    }
}}}
