﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/erpt/erpt_MultipleCategoryContext.h>
#include <nn/erpt/erpt_Types.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/time/time_SteadyClockTimePoint.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace erpt { namespace sf { // NOLINT(whitespace/braces)

class IContext;

class IManager;

class IReport;

class ISession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IContext, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IContext)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SubmitContext, (const ::nn::sf::InBuffer& contextBufferIn, const ::nn::sf::InBuffer& stringsBufferIn))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateReport, (::nn::erpt::ReportType type, const ::nn::sf::InBuffer& contextBufferIn, const ::nn::sf::InBuffer& stringsBufferIn, const ::nn::sf::InBuffer& metaBufferIn))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetInitialLaunchSettingsCompletionTime, (const ::nn::time::SteadyClockTimePoint& timePoint))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearInitialLaunchSettingsCompletionTime)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UpdatePowerOnTime)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UpdateAwakeTime)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SubmitMultipleCategoryContext, (const ::nn::erpt::MultipleCategoryContextEntry& contextEntryIn, const ::nn::sf::InBuffer& stringsBufferIn))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IContext)

        ::nn::Result SubmitContext(const ::nn::sf::InBuffer& contextBufferIn, const ::nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SubmitContext, (contextBufferIn, stringsBufferIn));
        }

        ::nn::Result CreateReport(::nn::erpt::ReportType type, const ::nn::sf::InBuffer& contextBufferIn, const ::nn::sf::InBuffer& stringsBufferIn, const ::nn::sf::InBuffer& metaBufferIn) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateReport, (type, contextBufferIn, stringsBufferIn, metaBufferIn));
        }

        ::nn::Result SetInitialLaunchSettingsCompletionTime(const ::nn::time::SteadyClockTimePoint& timePoint) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetInitialLaunchSettingsCompletionTime, (timePoint));
        }

        ::nn::Result ClearInitialLaunchSettingsCompletionTime() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearInitialLaunchSettingsCompletionTime);
        }

        ::nn::Result UpdatePowerOnTime() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UpdatePowerOnTime);
        }

        ::nn::Result UpdateAwakeTime() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UpdateAwakeTime);
        }

        ::nn::Result SubmitMultipleCategoryContext(const ::nn::erpt::MultipleCategoryContextEntry& contextEntryIn, const ::nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SubmitMultipleCategoryContext, (contextEntryIn, stringsBufferIn));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IContext
    {
    public:
        nn::Result SubmitContext(const nn::sf::InBuffer& contextBufferIn, const nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT;
        nn::Result CreateReport(nn::erpt::ReportType type, const nn::sf::InBuffer& contextBufferIn, const nn::sf::InBuffer& stringsBufferIn, const nn::sf::InBuffer& metaBufferIn) NN_NOEXCEPT;
        nn::Result SetInitialLaunchSettingsCompletionTime(const nn::time::SteadyClockTimePoint& timePoint) NN_NOEXCEPT;
        nn::Result ClearInitialLaunchSettingsCompletionTime() NN_NOEXCEPT;
        nn::Result UpdatePowerOnTime() NN_NOEXCEPT;
        nn::Result UpdateAwakeTime() NN_NOEXCEPT;
        nn::Result SubmitMultipleCategoryContext(const nn::erpt::MultipleCategoryContextEntry& contextEntryIn, const nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SubmitContext(const nn::sf::InBuffer& contextBufferIn, const nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT;
    nn::Result CreateReport(nn::erpt::ReportType type, const nn::sf::InBuffer& contextBufferIn, const nn::sf::InBuffer& stringsBufferIn, const nn::sf::InBuffer& metaBufferIn) NN_NOEXCEPT;
    nn::Result SetInitialLaunchSettingsCompletionTime(const nn::time::SteadyClockTimePoint& timePoint) NN_NOEXCEPT;
    nn::Result ClearInitialLaunchSettingsCompletionTime() NN_NOEXCEPT;
    nn::Result UpdatePowerOnTime() NN_NOEXCEPT;
    nn::Result UpdateAwakeTime() NN_NOEXCEPT;
    nn::Result SubmitMultipleCategoryContext(const nn::erpt::MultipleCategoryContextEntry& contextEntryIn, const nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::erpt::sf::IContext))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SubmitContext, (const ::nn::sf::InBuffer& contextBufferIn, const ::nn::sf::InBuffer& stringsBufferIn))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SubmitContext, (contextBufferIn, stringsBufferIn));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateReport, (::nn::erpt::ReportType type, const ::nn::sf::InBuffer& contextBufferIn, const ::nn::sf::InBuffer& stringsBufferIn, const ::nn::sf::InBuffer& metaBufferIn))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateReport, (type, contextBufferIn, stringsBufferIn, metaBufferIn));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInitialLaunchSettingsCompletionTime, (const ::nn::time::SteadyClockTimePoint& timePoint))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetInitialLaunchSettingsCompletionTime, (timePoint));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearInitialLaunchSettingsCompletionTime)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearInitialLaunchSettingsCompletionTime);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UpdatePowerOnTime)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UpdatePowerOnTime);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UpdateAwakeTime)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UpdateAwakeTime);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SubmitMultipleCategoryContext, (const ::nn::erpt::MultipleCategoryContextEntry& contextEntryIn, const ::nn::sf::InBuffer& stringsBufferIn))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SubmitMultipleCategoryContext, (contextEntryIn, stringsBufferIn));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::erpt::sf::IContext>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::erpt::sf::IContext))

    // nn::Result SubmitContext(const nn::sf::InBuffer& contextBufferIn, const nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SubmitContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(contextBufferIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(stringsBufferIn, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (contextBufferIn, stringsBufferIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contextBufferIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stringsBufferIn)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SubmitContext)

    // nn::Result CreateReport(nn::erpt::ReportType type, const nn::sf::InBuffer& contextBufferIn, const nn::sf::InBuffer& stringsBufferIn, const nn::sf::InBuffer& metaBufferIn) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(contextBufferIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(stringsBufferIn, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(metaBufferIn, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (contextBufferIn, stringsBufferIn, metaBufferIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::erpt::ReportType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contextBufferIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stringsBufferIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(metaBufferIn)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateReport)

    // nn::Result SetInitialLaunchSettingsCompletionTime(const nn::time::SteadyClockTimePoint& timePoint) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetInitialLaunchSettingsCompletionTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timePoint, (::nn::time::SteadyClockTimePoint), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (timePoint))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timePoint)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetInitialLaunchSettingsCompletionTime)

    // nn::Result ClearInitialLaunchSettingsCompletionTime() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearInitialLaunchSettingsCompletionTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearInitialLaunchSettingsCompletionTime)

    // nn::Result UpdatePowerOnTime() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdatePowerOnTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdatePowerOnTime)

    // nn::Result UpdateAwakeTime() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateAwakeTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateAwakeTime)

    // nn::Result SubmitMultipleCategoryContext(const nn::erpt::MultipleCategoryContextEntry& contextEntryIn, const nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SubmitMultipleCategoryContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(contextEntryIn, 0, (const ::nn::erpt::MultipleCategoryContextEntry&), 1224, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(stringsBufferIn, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (contextEntryIn, stringsBufferIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contextEntryIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stringsBufferIn)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SubmitMultipleCategoryContext)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::erpt::ReportType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::SteadyClockTimePoint), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::erpt::MultipleCategoryContextEntry), 1224, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::erpt::sf::IContext, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::erpt::sf::IContext))

    // nn::Result SubmitContext(const nn::sf::InBuffer& contextBufferIn, const nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SubmitContext, (const ::nn::sf::InBuffer& contextBufferIn, const ::nn::sf::InBuffer& stringsBufferIn))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SubmitContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contextBufferIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stringsBufferIn)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SubmitContext)
    }

    // nn::Result CreateReport(nn::erpt::ReportType type, const nn::sf::InBuffer& contextBufferIn, const nn::sf::InBuffer& stringsBufferIn, const nn::sf::InBuffer& metaBufferIn) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateReport, (::nn::erpt::ReportType type, const ::nn::sf::InBuffer& contextBufferIn, const ::nn::sf::InBuffer& stringsBufferIn, const ::nn::sf::InBuffer& metaBufferIn))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contextBufferIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stringsBufferIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(metaBufferIn)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateReport)
    }

    // nn::Result SetInitialLaunchSettingsCompletionTime(const nn::time::SteadyClockTimePoint& timePoint) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInitialLaunchSettingsCompletionTime, (const ::nn::time::SteadyClockTimePoint& timePoint))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetInitialLaunchSettingsCompletionTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timePoint)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetInitialLaunchSettingsCompletionTime)
    }

    // nn::Result ClearInitialLaunchSettingsCompletionTime() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearInitialLaunchSettingsCompletionTime)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearInitialLaunchSettingsCompletionTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearInitialLaunchSettingsCompletionTime)
    }

    // nn::Result UpdatePowerOnTime() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UpdatePowerOnTime)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdatePowerOnTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdatePowerOnTime)
    }

    // nn::Result UpdateAwakeTime() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UpdateAwakeTime)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateAwakeTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateAwakeTime)
    }

    // nn::Result SubmitMultipleCategoryContext(const nn::erpt::MultipleCategoryContextEntry& contextEntryIn, const nn::sf::InBuffer& stringsBufferIn) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SubmitMultipleCategoryContext, (const ::nn::erpt::MultipleCategoryContextEntry& contextEntryIn, const ::nn::sf::InBuffer& stringsBufferIn))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SubmitMultipleCategoryContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contextEntryIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stringsBufferIn)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SubmitMultipleCategoryContext)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::erpt::sf::IContext>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::erpt::sf::IContext))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SubmitContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(contextBufferIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(stringsBufferIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SubmitContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(contextBufferIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(stringsBufferIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(contextBufferIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(stringsBufferIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(metaBufferIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(contextBufferIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(stringsBufferIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(metaBufferIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetInitialLaunchSettingsCompletionTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetInitialLaunchSettingsCompletionTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timePoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearInitialLaunchSettingsCompletionTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearInitialLaunchSettingsCompletionTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdatePowerOnTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdatePowerOnTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateAwakeTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateAwakeTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SubmitMultipleCategoryContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(contextEntryIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(stringsBufferIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SubmitMultipleCategoryContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(contextEntryIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(stringsBufferIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SubmitContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetInitialLaunchSettingsCompletionTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearInitialLaunchSettingsCompletionTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdatePowerOnTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateAwakeTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SubmitMultipleCategoryContext)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::erpt::sf::IContext))

namespace nn { namespace erpt { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReportList, (const ::nn::sf::OutBuffer& listBufferOut, ::nn::erpt::ReportType filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandleOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CleanupReports)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteReport, (const ::nn::erpt::ReportId& reportId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStorageUsageStatistics, (::nn::sf::Out<::nn::erpt::StorageUsageStatistics> outUsage))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManager)

        ::nn::Result GetReportList(const ::nn::sf::OutBuffer& listBufferOut, ::nn::erpt::ReportType filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReportList, (listBufferOut, filter));
        }

        ::nn::Result GetEvent(::nn::sf::Out<::nn::sf::NativeHandle> eventHandleOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetEvent, (eventHandleOut));
        }

        ::nn::Result CleanupReports() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CleanupReports);
        }

        ::nn::Result DeleteReport(const ::nn::erpt::ReportId& reportId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteReport, (reportId));
        }

        ::nn::Result GetStorageUsageStatistics(::nn::sf::Out<::nn::erpt::StorageUsageStatistics> outUsage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStorageUsageStatistics, (outUsage));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManager
    {
    public:
        nn::Result GetReportList(const nn::sf::OutBuffer& listBufferOut, nn::erpt::ReportType filter) NN_NOEXCEPT;
        nn::Result GetEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandleOut) NN_NOEXCEPT;
        nn::Result CleanupReports() NN_NOEXCEPT;
        nn::Result DeleteReport(const nn::erpt::ReportId& reportId) NN_NOEXCEPT;
        nn::Result GetStorageUsageStatistics(nn::sf::Out<nn::erpt::StorageUsageStatistics> outUsage) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetReportList(const nn::sf::OutBuffer& listBufferOut, nn::erpt::ReportType filter) NN_NOEXCEPT;
    nn::Result GetEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandleOut) NN_NOEXCEPT;
    nn::Result CleanupReports() NN_NOEXCEPT;
    nn::Result DeleteReport(const nn::erpt::ReportId& reportId) NN_NOEXCEPT;
    nn::Result GetStorageUsageStatistics(nn::sf::Out<nn::erpt::StorageUsageStatistics> outUsage) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::erpt::sf::IManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReportList, (const ::nn::sf::OutBuffer& listBufferOut, ::nn::erpt::ReportType filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReportList, (listBufferOut, filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandleOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetEvent, (eventHandleOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupReports)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CleanupReports);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteReport, (const ::nn::erpt::ReportId& reportId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteReport, (reportId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStorageUsageStatistics, (::nn::sf::Out<::nn::erpt::StorageUsageStatistics> outUsage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStorageUsageStatistics, (outUsage));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::erpt::sf::IManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::erpt::sf::IManager))

    // nn::Result GetReportList(const nn::sf::OutBuffer& listBufferOut, nn::erpt::ReportType filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReportList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(listBufferOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (listBufferOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::erpt::ReportType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(listBufferOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReportList)

    // nn::Result GetEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandleOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(eventHandleOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (eventHandleOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventHandleOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetEvent)

    // nn::Result CleanupReports() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanupReports)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanupReports)

    // nn::Result DeleteReport(const nn::erpt::ReportId& reportId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reportId, (::nn::erpt::ReportId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (reportId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reportId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteReport)

    // nn::Result GetStorageUsageStatistics(nn::sf::Out<nn::erpt::StorageUsageStatistics> outUsage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStorageUsageStatistics)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outUsage, (::nn::erpt::StorageUsageStatistics), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outUsage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUsage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStorageUsageStatistics)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::erpt::ReportType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::erpt::ReportId), 20, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::erpt::StorageUsageStatistics), 56, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::erpt::sf::IManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::erpt::sf::IManager))

    // nn::Result GetReportList(const nn::sf::OutBuffer& listBufferOut, nn::erpt::ReportType filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReportList, (const ::nn::sf::OutBuffer& listBufferOut, ::nn::erpt::ReportType filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReportList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(listBufferOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReportList)
    }

    // nn::Result GetEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandleOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandleOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventHandleOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetEvent)
    }

    // nn::Result CleanupReports() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupReports)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanupReports)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanupReports)
    }

    // nn::Result DeleteReport(const nn::erpt::ReportId& reportId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteReport, (const ::nn::erpt::ReportId& reportId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reportId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteReport)
    }

    // nn::Result GetStorageUsageStatistics(nn::sf::Out<nn::erpt::StorageUsageStatistics> outUsage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStorageUsageStatistics, (::nn::sf::Out<::nn::erpt::StorageUsageStatistics> outUsage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStorageUsageStatistics)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUsage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStorageUsageStatistics)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::erpt::sf::IManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::erpt::sf::IManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReportList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(listBufferOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReportList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(listBufferOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(eventHandleOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(eventHandleOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanupReports)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanupReports)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reportId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStorageUsageStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStorageUsageStatistics)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outUsage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReportList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanupReports)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStorageUsageStatistics)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::erpt::sf::IManager))

namespace nn { namespace erpt { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IReport, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IReport)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Open, (const ::nn::erpt::ReportId& reportId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<::std::uint32_t> readCountOut, const ::nn::sf::OutBuffer& readBufferOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetFlags, (::nn::erpt::ReportFlagSet flagsIn))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFlags, (::nn::sf::Out<::nn::erpt::ReportFlagSet> flagsOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Close)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::int64_t> sizeOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IReport)

        ::nn::Result Open(const ::nn::erpt::ReportId& reportId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Open, (reportId));
        }

        ::nn::Result Read(::nn::sf::Out<::std::uint32_t> readCountOut, const ::nn::sf::OutBuffer& readBufferOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Read, (readCountOut, readBufferOut));
        }

        ::nn::Result SetFlags(::nn::erpt::ReportFlagSet flagsIn) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetFlags, (flagsIn));
        }

        ::nn::Result GetFlags(::nn::sf::Out<::nn::erpt::ReportFlagSet> flagsOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFlags, (flagsOut));
        }

        ::nn::Result Close() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Close);
        }

        ::nn::Result GetSize(::nn::sf::Out<::std::int64_t> sizeOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSize, (sizeOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IReport
    {
    public:
        nn::Result Open(const nn::erpt::ReportId& reportId) NN_NOEXCEPT;
        nn::Result Read(nn::sf::Out<std::uint32_t> readCountOut, const nn::sf::OutBuffer& readBufferOut) NN_NOEXCEPT;
        nn::Result SetFlags(nn::erpt::ReportFlagSet flagsIn) NN_NOEXCEPT;
        nn::Result GetFlags(nn::sf::Out<nn::erpt::ReportFlagSet> flagsOut) NN_NOEXCEPT;
        nn::Result Close() NN_NOEXCEPT;
        nn::Result GetSize(nn::sf::Out<std::int64_t> sizeOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Open(const nn::erpt::ReportId& reportId) NN_NOEXCEPT;
    nn::Result Read(nn::sf::Out<std::uint32_t> readCountOut, const nn::sf::OutBuffer& readBufferOut) NN_NOEXCEPT;
    nn::Result SetFlags(nn::erpt::ReportFlagSet flagsIn) NN_NOEXCEPT;
    nn::Result GetFlags(nn::sf::Out<nn::erpt::ReportFlagSet> flagsOut) NN_NOEXCEPT;
    nn::Result Close() NN_NOEXCEPT;
    nn::Result GetSize(nn::sf::Out<std::int64_t> sizeOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::erpt::sf::IReport))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Open, (const ::nn::erpt::ReportId& reportId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Open, (reportId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<::std::uint32_t> readCountOut, const ::nn::sf::OutBuffer& readBufferOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Read, (readCountOut, readBufferOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetFlags, (::nn::erpt::ReportFlagSet flagsIn))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetFlags, (flagsIn));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFlags, (::nn::sf::Out<::nn::erpt::ReportFlagSet> flagsOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFlags, (flagsOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Close)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Close);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::int64_t> sizeOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSize, (sizeOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::erpt::sf::IReport>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::erpt::sf::IReport))

    // nn::Result Open(const nn::erpt::ReportId& reportId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Open)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reportId, (::nn::erpt::ReportId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (reportId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reportId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Open)

    // nn::Result Read(nn::sf::Out<std::uint32_t> readCountOut, const nn::sf::OutBuffer& readBufferOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Read)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(readBufferOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (readBufferOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(readCountOut, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (readCountOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(readCountOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(readBufferOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Read)

    // nn::Result SetFlags(nn::erpt::ReportFlagSet flagsIn) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetFlags)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flagsIn, (::nn::erpt::ReportFlagSet), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (flagsIn))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flagsIn)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetFlags)

    // nn::Result GetFlags(nn::sf::Out<nn::erpt::ReportFlagSet> flagsOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFlags)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(flagsOut, (::nn::erpt::ReportFlagSet), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (flagsOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flagsOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFlags)

    // nn::Result Close() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Close)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Close)

    // nn::Result GetSize(nn::sf::Out<std::int64_t> sizeOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(sizeOut, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (sizeOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sizeOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSize)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::erpt::ReportId), 20, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::erpt::ReportFlagSet), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::erpt::sf::IReport, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::erpt::sf::IReport))

    // nn::Result Open(const nn::erpt::ReportId& reportId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Open, (const ::nn::erpt::ReportId& reportId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Open)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reportId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Open)
    }

    // nn::Result Read(nn::sf::Out<std::uint32_t> readCountOut, const nn::sf::OutBuffer& readBufferOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<::std::uint32_t> readCountOut, const ::nn::sf::OutBuffer& readBufferOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Read)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(readCountOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(readBufferOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Read)
    }

    // nn::Result SetFlags(nn::erpt::ReportFlagSet flagsIn) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetFlags, (::nn::erpt::ReportFlagSet flagsIn))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetFlags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flagsIn)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetFlags)
    }

    // nn::Result GetFlags(nn::sf::Out<nn::erpt::ReportFlagSet> flagsOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFlags, (::nn::sf::Out<::nn::erpt::ReportFlagSet> flagsOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFlags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flagsOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFlags)
    }

    // nn::Result Close() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Close)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Close)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Close)
    }

    // nn::Result GetSize(nn::sf::Out<std::int64_t> sizeOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::int64_t> sizeOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sizeOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSize)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::erpt::sf::IReport>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::erpt::sf::IReport))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Open)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Open)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reportId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Read)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(readBufferOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Read)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(readCountOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(readBufferOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetFlags)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flagsIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFlags)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(flagsOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(sizeOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Open)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Read)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSize)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::erpt::sf::IReport))

namespace nn { namespace erpt { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenReport, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::erpt::sf::IReport>> reportHandleOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenManager, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::erpt::sf::IManager>> managerHandleOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISession)

        ::nn::Result OpenReport(::nn::sf::Out<::nn::sf::SharedPointer<::nn::erpt::sf::IReport>> reportHandleOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenReport, (reportHandleOut));
        }

        ::nn::Result OpenManager(::nn::sf::Out<::nn::sf::SharedPointer<::nn::erpt::sf::IManager>> managerHandleOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenManager, (managerHandleOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISession
    {
    public:
        nn::Result OpenReport(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IReport>> reportHandleOut) NN_NOEXCEPT;
        nn::Result OpenManager(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IManager>> managerHandleOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenReport(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IReport>> reportHandleOut) NN_NOEXCEPT;
    nn::Result OpenManager(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IManager>> managerHandleOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::erpt::sf::ISession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenReport, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::erpt::sf::IReport>> reportHandleOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenReport, (reportHandleOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenManager, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::erpt::sf::IManager>> managerHandleOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenManager, (managerHandleOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::erpt::sf::ISession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::erpt::sf::ISession))

    // nn::Result OpenReport(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IReport>> reportHandleOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(reportHandleOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (reportHandleOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reportHandleOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenReport)

    // nn::Result OpenManager(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IManager>> managerHandleOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenManager)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(managerHandleOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (managerHandleOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(managerHandleOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenManager)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::erpt::sf::ISession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::erpt::sf::ISession))

    // nn::Result OpenReport(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IReport>> reportHandleOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenReport, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::erpt::sf::IReport>> reportHandleOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reportHandleOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenReport)
    }

    // nn::Result OpenManager(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IManager>> managerHandleOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenManager, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::erpt::sf::IManager>> managerHandleOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenManager)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(managerHandleOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenManager)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::erpt::sf::ISession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::erpt::sf::ISession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::erpt::sf::IReport>), reportHandleOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(reportHandleOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(reportHandleOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenManager)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::erpt::sf::IManager>), managerHandleOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenManager)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(managerHandleOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(managerHandleOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenManager)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::erpt::sf::ISession))
