﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 *  @file
 *  @brief Error report multiple category context class.
*/

#include <nn/os.h>
#include <nn/erpt/erpt_Types.h>

namespace nn   {
namespace erpt {

const uint32_t CategoriesPerMultipleCategoryContext = 16;
const uint32_t FieldsPerMultipleCategoryContext = CategoriesPerMultipleCategoryContext * 4;

struct MultipleCategoryContextEntry
{
    uint32_t   version;
    uint32_t   categoryCount;
    CategoryId categories[CategoriesPerMultipleCategoryContext];
    uint32_t   fieldCounts[CategoriesPerMultipleCategoryContext];
    uint32_t   arrayBufferCounts[CategoriesPerMultipleCategoryContext];
    FieldEntry fields[FieldsPerMultipleCategoryContext];
};

class MultipleCategoryContext
{
private:
    int m_TotalFieldCount;
    MultipleCategoryContextEntry m_Context;
    uint8_t     m_ArrayBuffer[ArrayBufferLength];
    uint8_t*    m_pArrayBuffer;
    uint32_t    m_ArrayFreeCount;
    uint32_t    m_ArrayBufferSize;
    uint32_t    m_ArrayBufferOffset;

    nn::Result Add(FieldId id, const uint8_t* pBuffer, uint32_t bufferLength, FieldType type) NN_NOEXCEPT;

public:
    MultipleCategoryContext() NN_NOEXCEPT;
    MultipleCategoryContext(uint8_t* arrayBuffer, uint32_t arrayBufferSize) NN_NOEXCEPT;

    void Reset() NN_NOEXCEPT;
    nn::Result MoveToNextCategory(nn::erpt::CategoryId id) NN_NOEXCEPT;

    nn::Result Add(FieldId id, bool valueBool) NN_NOEXCEPT;
    nn::Result Add(FieldId id, uint64_t valueU64) NN_NOEXCEPT;
    nn::Result Add(FieldId id, uint32_t valueU32) NN_NOEXCEPT;
    nn::Result Add(FieldId id, uint16_t valueU16) NN_NOEXCEPT;
    nn::Result Add(FieldId id, uint8_t valueU8) NN_NOEXCEPT;
    nn::Result Add(FieldId id, int64_t valueI64) NN_NOEXCEPT;
    nn::Result Add(FieldId id, int32_t valueI32) NN_NOEXCEPT;
    nn::Result Add(FieldId id, int16_t valueI16) NN_NOEXCEPT;
    nn::Result Add(FieldId id, int8_t valueI8) NN_NOEXCEPT;
    nn::Result Add(FieldId id, const char* pBuffer, uint32_t bufferLength) NN_NOEXCEPT;
    nn::Result Add(FieldId id, const uint8_t* pBuffer, uint32_t bufferLength) NN_NOEXCEPT;
    nn::Result Add(FieldId id, const uint32_t* pArray, uint32_t elementCount) NN_NOEXCEPT;
    nn::Result Add(FieldId id, const uint64_t* pArray, uint32_t elementCount) NN_NOEXCEPT;
    nn::Result Add(FieldId id, const int32_t*  pArray, uint32_t elementCount) NN_NOEXCEPT;
    nn::Result Add(FieldId id, const int64_t*  pArray, uint32_t elementCount) NN_NOEXCEPT;
    nn::Result SubmitContext() NN_NOEXCEPT;
};

}}
