﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Eコマース処理を行うAPIに必要な型や定数などのシステム向け定義
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ec/ec_ShopTypes.h>

namespace nn { namespace ec {

/**
 * @brief ショップの割引に利用されるクーポンを個別に識別するためのIDです。
 */
struct CouponId
{
    Bit64 value;
    /**
     * @brief 無効であることを表す CouponId 値を返します。
     */
    static CouponId GetInvalidId() NN_NOEXCEPT
    {
        CouponId id = { 0 };
        return id;
    }
};

inline bool operator == (const CouponId& lhs, const CouponId& rhs) NN_NOEXCEPT
{
    return lhs.value == rhs.value;
}

inline bool operator != (const CouponId& lhs, const CouponId& rhs) NN_NOEXCEPT
{
    return lhs.value != rhs.value;
}

}}
