﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief ショップの機能を提供するAPIの定義
 */

#pragma once

#include <nn/ec/ec_ResultShop.h>
#include <nn/ec/ec_ShopTypes.h>

namespace nn { namespace ec {

/**
 * @name ニンテンドーeショップのシステム経由での購入時に確認を行うための関数
 * @{
 */

/**
 * @brief 商品の購入前に必要な事項の確認を行います。
 * @param[in] selectedUser 購入の際に利用するユーザーを表すハンドル
 * @param[in] totalPriceRawValue 商品価格の raw データ(数値のみで構成されたデータ)を表す文字列
 * @return 処理の結果を表す nn::Result 値
 * @retval nn::ResultSuccess 確認処理が行われ、購入処理が可能です。
 * @retval nn::ec::ResultShopCanceled ユーザーによって操作がキャンセルされました。
 * @retval nn::ec::ResultShopInvalidParameter 指定されたパラメーターが不正です。
 * @pre
 *  - selectedUser が有効なハンドルであり、そのハンドルが指すユーザーに対して
 *    ニンテンドーアカウントの連携が行われている
 *
 * @details
 * - 本関数は内部でUI表示を行うため、呼び出し元スレッドをブロックします。
 * - totalPriceRawValue が指す文字列は 0 以上の数を表現したものである必要があり、
 *   それを満たさない場合、本関数は nn::ec::ResultShopInvalidParameter を返します。
 *   ただし、値は整数である必要は無く、小数点を含むことができます。@n
 *   通常は購入処理のためにサーバーから情報取得を行い、そこで得られる
 *   合計金額のデータを指定します。
 */
nn::Result RequestPurchaseAuthorization(const nn::account::UserHandle& selectedUser,
    const char* totalPriceRawValue) NN_NOEXCEPT;

/**
 * @}
 */

}}
