﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace dauth { namespace detail { // NOLINT(whitespace/braces)

class IAsyncResult;

class IService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAsyncResult, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAsyncResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsAvailable, (::nn::sf::Out<bool> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAsyncResult)

        ::nn::Result GetResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetResult);
        }

        ::nn::Result Cancel() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Cancel);
        }

        ::nn::Result IsAvailable(::nn::sf::Out<bool> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsAvailable, (pOut));
        }

        ::nn::Result GetSystemEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemEvent, (pOutHandle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAsyncResult
    {
    public:
        nn::Result GetResult() NN_NOEXCEPT;
        nn::Result Cancel() NN_NOEXCEPT;
        nn::Result IsAvailable(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
        nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetResult() NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;
    nn::Result IsAvailable(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::dauth::detail::IAsyncResult))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Cancel);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAvailable, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsAvailable, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemEvent, (pOutHandle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::dauth::detail::IAsyncResult>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::dauth::detail::IAsyncResult))

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetResult)

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Cancel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Cancel)

    // nn::Result IsAvailable(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAvailable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAvailable)

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemEvent)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::dauth::detail::IAsyncResult, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::dauth::detail::IAsyncResult))

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetResult)
    }

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Cancel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Cancel)
    }

    // nn::Result IsAvailable(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAvailable, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAvailable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAvailable)
    }

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::dauth::detail::IAsyncResult>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::dauth::detail::IAsyncResult))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAvailable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAvailable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAvailable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::dauth::detail::IAsyncResult))

namespace nn { namespace dauth { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnsureAuthenticationTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>> outAsync, ::std::uint64_t clientId, bool refresh))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAuthenticationTokenCache, (::nn::sf::Out<::std::int64_t> outExpiration, const ::nn::sf::OutBuffer& buffer, ::std::uint64_t clientId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnsureEdgeTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>> outAsync, ::std::uint64_t clientId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadEdgeTokenCache, (::nn::sf::Out<::std::int64_t> outExpiration, const ::nn::sf::OutBuffer& buffer, ::std::uint64_t clientId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IService)

        ::nn::Result EnsureAuthenticationTokenCacheAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>> outAsync, ::std::uint64_t clientId, bool refresh) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnsureAuthenticationTokenCacheAsync, (outAsync, clientId, refresh));
        }

        ::nn::Result LoadAuthenticationTokenCache(::nn::sf::Out<::std::int64_t> outExpiration, const ::nn::sf::OutBuffer& buffer, ::std::uint64_t clientId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), buffer)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = buffer)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAuthenticationTokenCache, (outExpiration, buffer, clientId));
        }

        ::nn::Result EnsureEdgeTokenCacheAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>> outAsync, ::std::uint64_t clientId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnsureEdgeTokenCacheAsync, (outAsync, clientId));
        }

        ::nn::Result LoadEdgeTokenCache(::nn::sf::Out<::std::int64_t> outExpiration, const ::nn::sf::OutBuffer& buffer, ::std::uint64_t clientId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), buffer)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = buffer)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadEdgeTokenCache, (outExpiration, buffer, clientId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IService
    {
    public:
        nn::Result EnsureAuthenticationTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::dauth::detail::IAsyncResult>> outAsync, std::uint64_t clientId, bool refresh) NN_NOEXCEPT;
        nn::Result LoadAuthenticationTokenCache(nn::sf::Out<std::int64_t> outExpiration, const nn::sf::OutBuffer& buffer, std::uint64_t clientId) NN_NOEXCEPT;
        nn::Result EnsureEdgeTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::dauth::detail::IAsyncResult>> outAsync, std::uint64_t clientId) NN_NOEXCEPT;
        nn::Result LoadEdgeTokenCache(nn::sf::Out<std::int64_t> outExpiration, const nn::sf::OutBuffer& buffer, std::uint64_t clientId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result EnsureAuthenticationTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::dauth::detail::IAsyncResult>> outAsync, std::uint64_t clientId, bool refresh) NN_NOEXCEPT;
    nn::Result LoadAuthenticationTokenCache(nn::sf::Out<std::int64_t> outExpiration, const nn::sf::OutBuffer& buffer, std::uint64_t clientId) NN_NOEXCEPT;
    nn::Result EnsureEdgeTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::dauth::detail::IAsyncResult>> outAsync, std::uint64_t clientId) NN_NOEXCEPT;
    nn::Result LoadEdgeTokenCache(nn::sf::Out<std::int64_t> outExpiration, const nn::sf::OutBuffer& buffer, std::uint64_t clientId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::dauth::detail::IService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureAuthenticationTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>> outAsync, ::std::uint64_t clientId, bool refresh))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnsureAuthenticationTokenCacheAsync, (outAsync, clientId, refresh));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAuthenticationTokenCache, (::nn::sf::Out<::std::int64_t> outExpiration, const ::nn::sf::OutBuffer& buffer, ::std::uint64_t clientId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAuthenticationTokenCache, (outExpiration, buffer, clientId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureEdgeTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>> outAsync, ::std::uint64_t clientId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnsureEdgeTokenCacheAsync, (outAsync, clientId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadEdgeTokenCache, (::nn::sf::Out<::std::int64_t> outExpiration, const ::nn::sf::OutBuffer& buffer, ::std::uint64_t clientId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadEdgeTokenCache, (outExpiration, buffer, clientId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::dauth::detail::IService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::dauth::detail::IService))

    // nn::Result EnsureAuthenticationTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::dauth::detail::IAsyncResult>> outAsync, std::uint64_t clientId, bool refresh) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnsureAuthenticationTokenCacheAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(refresh, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientId, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (refresh, clientId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(refresh)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnsureAuthenticationTokenCacheAsync)

    // nn::Result LoadAuthenticationTokenCache(nn::sf::Out<std::int64_t> outExpiration, const nn::sf::OutBuffer& buffer, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAuthenticationTokenCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (clientId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outExpiration, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outExpiration))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outExpiration), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAuthenticationTokenCache)

    // nn::Result EnsureEdgeTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::dauth::detail::IAsyncResult>> outAsync, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnsureEdgeTokenCacheAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (clientId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnsureEdgeTokenCacheAsync)

    // nn::Result LoadEdgeTokenCache(nn::sf::Out<std::int64_t> outExpiration, const nn::sf::OutBuffer& buffer, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadEdgeTokenCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (clientId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outExpiration, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outExpiration))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outExpiration), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadEdgeTokenCache)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::dauth::detail::IService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::dauth::detail::IService))

    // nn::Result EnsureAuthenticationTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::dauth::detail::IAsyncResult>> outAsync, std::uint64_t clientId, bool refresh) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureAuthenticationTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>> outAsync, ::std::uint64_t clientId, bool refresh))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnsureAuthenticationTokenCacheAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(refresh)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnsureAuthenticationTokenCacheAsync)
    }

    // nn::Result LoadAuthenticationTokenCache(nn::sf::Out<std::int64_t> outExpiration, const nn::sf::OutBuffer& buffer, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAuthenticationTokenCache, (::nn::sf::Out<::std::int64_t> outExpiration, const ::nn::sf::OutBuffer& buffer, ::std::uint64_t clientId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAuthenticationTokenCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outExpiration)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAuthenticationTokenCache)
    }

    // nn::Result EnsureEdgeTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::dauth::detail::IAsyncResult>> outAsync, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureEdgeTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>> outAsync, ::std::uint64_t clientId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnsureEdgeTokenCacheAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnsureEdgeTokenCacheAsync)
    }

    // nn::Result LoadEdgeTokenCache(nn::sf::Out<std::int64_t> outExpiration, const nn::sf::OutBuffer& buffer, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadEdgeTokenCache, (::nn::sf::Out<::std::int64_t> outExpiration, const ::nn::sf::OutBuffer& buffer, ::std::uint64_t clientId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadEdgeTokenCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outExpiration)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadEdgeTokenCache)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::dauth::detail::IService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::dauth::detail::IService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnsureAuthenticationTokenCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnsureAuthenticationTokenCacheAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(refresh)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAuthenticationTokenCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAuthenticationTokenCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outExpiration),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnsureEdgeTokenCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::dauth::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnsureEdgeTokenCacheAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadEdgeTokenCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadEdgeTokenCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outExpiration),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnsureAuthenticationTokenCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAuthenticationTokenCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnsureEdgeTokenCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadEdgeTokenCache)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::dauth::detail::IService))
