﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/dauth/dauth_Types.h>

namespace nn { namespace sf {
template <typename IServiceObject> class SharedPointer;
}} // ~namespace nn::sf

namespace nn { namespace dauth { namespace detail {
class IService;
}}} // ~namespace nn::dauth::detail

namespace nn { namespace dauth {

//! @name dauth サービスの開発者のみが使用する機能
//! @{

void InitializeWith(sf::SharedPointer<detail::IService>&& ptr) NN_NOEXCEPT;
void DebugSetServiceInitializer(sf::SharedPointer<detail::IService> (*initializer)()) NN_NOEXCEPT;
void DebugResetServiceAccessor() NN_NOEXCEPT;

//! @}

}} // ~namespace nn::dauth
