﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "../bpc_BoardPowerControlTypes.h"
#include "../bpc_PowerButtonTypes.h"
#include "../bpc_RtcTypes.h"

namespace nn { namespace bpc { namespace driver {

void ShutdownSystem() NN_NOEXCEPT;

void RebootSystem() NN_NOEXCEPT;

void SuspendIrq() NN_NOEXCEPT;

void ResumeIrq() NN_NOEXCEPT;

nn::Result GetWakeupReason(WakeupReason* pOutWakeupReason) NN_NOEXCEPT;

nn::Result GetShutdownReason(ShutdownReason* pOutShutdownReason) NN_NOEXCEPT;

nn::Result GetAcOk(bool* pOutAcOk) NN_NOEXCEPT;

void GetSleepButtonState(SleepButtonState* pOutState) NN_NOEXCEPT;

nn::Result GetPowerButtonEventPtr(nn::os::SystemEventType** pOutEventPtr, EventTarget target) NN_NOEXCEPT;

nn::Result GetBoardPowerControlEventPtr(nn::os::SystemEventType** pOutEventPtr, BoardPowerControlEventTarget target) NN_NOEXCEPT;

}}} // namepsace nn::bpc::driver
