﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/sf/sf_Types.h>
#include <nn/bpc/bpc_IBoardPowerControlManager.sfdl.h>
#include <nn/bpc/bpc_IRtcManager.sfdl.h>

namespace nn { namespace bpc {

void InitializeBoardPowerControlWith(nn::sf::SharedPointer<IBoardPowerControlManager> boardPowerControlManager) NN_NOEXCEPT;
void InitializeRtcWith(nn::sf::SharedPointer<IRtcManager> rtcManager) NN_NOEXCEPT;

nn::sf::SharedPointer<IBoardPowerControlManager> GetInternalBoardPowerControlManager() NN_NOEXCEPT;
nn::sf::SharedPointer<IRtcManager> GetInternalRtcManager() NN_NOEXCEPT;

}} // namespace nn::bpc
