﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace bpc {

/**
 * @brief @ref nn::bpc::GetEventHandle でハンドルを取得できるイベントです。
 */
enum EventTarget {
    EventTarget_Undefined = -1, //!< 無効なイベントです。
    EventTarget_SleepButtonShutdown, //!< 電源ボタンがシャットダウン要求に対応する時間だけ押下され続けたことを示します。
    EventTarget_SleepButtonManualResetWarning, //!< 強制電源断に入る直前の警告です。
    EventTarget_SleepButtonStateChanged, //!< 電源ボタンの押下状態が変化したことを示します。
};

}} // namespace nn::bpc
