﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace bpc {

typedef uint32_t WakeupReason;
const WakeupReason WakeupReasonNoReason    = 0x00000000UL; //!< いずれのウェイク原因にも対応しません。
const WakeupReason WakeupReasonAcOkOn      = 0x00000020UL; //!< 外部電源が接続されました。
const WakeupReason WakeupReasonAcOkOff     = 0x00000010UL; //!< 外部電源が抜去されました。
const WakeupReason WakeupReasonPowerButton = 0x00000008UL; //!< 電源ボタンが押されました。
const WakeupReason WakeupReasonRtc         = 0x00000004UL; //!< RTC が割り込みを発生させました。
// const WakeupReason WakeupReasonAlarm1      = 0x00000002UL; //!< RTC1 のアラームが鳴りました（現在は対応していません）
// const WakeupReason WakeupReasonAlarm2      = 0x00000001UL; //!< RTC2 のアラームが鳴りました（現在は対応していません）

/**
 * @brief 直前のシャットダウンもしくはリブートの原因を示します。
 */
typedef uint32_t ShutdownReason;
const ShutdownReason ShutdownReasonNoReason                = 0x00000000UL; //!< いずれのシャットダウン・リブート原因にも対応しません。
const ShutdownReason ShutdownReasonResetInput              = 0x00000080UL; //!< PMIC 内部の Reset Input が有効になったためにシャットダウンしました。
const ShutdownReason ShutdownReasonMainBatteryUnderVoltage = 0x00000040UL; //!< PMIC の検知する電池電圧が下限を下回りました。
const ShutdownReason ShutdownReasonMainBatteryOverVoltage  = 0x00000020UL; //!< PMIC の検知する電池電圧が上限を上回りました。
const ShutdownReason ShutdownReasonTemperatureOverload     = 0x00000008UL; //!< PMIC の検知する温度が上限を上回りました。
const ShutdownReason ShutdownReasonHardReset               = 0x00000004UL; //!< スリープボタン長押しにより強制電源断されました。
const ShutdownReason ShutdownReasonShutdownPin             = 0x00000001UL; //!< PMIC へのシャットダウン入力が有効になりました。

/**
 * @brief @ref nn::bpc::GetBoardPowerControlEventHandle でハンドルを取得できるイベントです。
 */
enum BoardPowerControlEventTarget {
    BoardPowerControlEventTarget_Undefined = -1, //!< 無効なイベントです。
    BoardPowerControlEventTarget_AcOkRising, //!< 外部電源からの給電が開始されたことを表します。
};

}} // namespace nn::bpc
