﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace bpc {

typedef uint32_t WakeupReason;
const WakeupReason WakeupReasonNoReason = 0x00000000UL;

/**
 * @brief 直前のシャットダウンもしくはリブートの原因を示します。
 */
typedef uint32_t ShutdownReason;
const ShutdownReason ShutdownReasonNoReason = 0x00000000UL; //!< いずれのシャットダウン・リブート原因にも対応しません。

/**
 * @brief @ref nn::bpc::GetBoardPowerControlEventHandle でハンドルを取得できるイベントです。
 */
enum BoardPowerControlEventTarget {
    BoardPowerControlEventTarget_Undefined = -1, //!< 無効なイベントです。
};

}} // namespace nn::bpc
