﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       GATT Attribute クラスの宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/bluetooth/bluetooth_LeTypes.h>

namespace nn { namespace bluetooth {
    /**
     * @brief       GATT Attribute を表すクラスです
     */
    class GattAttribute
    {
    public:
        /**
         * @brief           コンストラクタです
         *
         * @details         全パラメータが無効な値で初期化されたGATT Attribute オブジェクトを生成します
         */
        GattAttribute() NN_NOEXCEPT;

        /**
         * @brief           コンストラクタです
         *
         * @details         与えられたパラメータで初期化されたGATT Attribute オブジェクトを生成します
         *
         * @param[in]       uuid                GATT Attribute UUID
         * @param[in]       handle              GATT Attribute Handle
         * @param[in]       connectionHandle    GATT Server との接続ハンドル
         */
        GattAttribute(const GattAttributeUuid& uuid, uint16_t handle, uint32_t connectionHandle) NN_NOEXCEPT;

        /**
         * @brief           デストラクタです
         */
        virtual ~GattAttribute() NN_NOEXCEPT;

        /**
         * @brief           タイプを取得します
         */
        virtual GattAttributeType GetType() const NN_NOEXCEPT;

        /**
         * @brief           UUID を取得します
         */
        virtual GattAttributeUuid GetUuid() const NN_NOEXCEPT;

        /**
         * @brief           Handle を取得します
         */
        virtual uint16_t GetHandle() const NN_NOEXCEPT;

        /**
         * @brief           接続ハンドルを取得します
         */
        virtual uint32_t GetConnectionHandle() const NN_NOEXCEPT;

    protected:
        GattAttributeType m_Type;

        GattAttributeUuid m_Uuid;

        uint16_t m_Handle;

        uint32_t m_ConnectionHandle;
    };
}} // namespace nn::bluetooth
