﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/**
 * @file
 * @brief
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace bluetooth {

const int AddressLength = 6;  //!<   アドレス長です。

/**
 * @brief       Bluetooth のアドレスを表す構造体です
 */
struct Address
{
    uint8_t address[AddressLength];     //!< Bluetooth アドレスの値です

    /**
     * @brief      アドレスが一致しているかどうか比較します
     */
    bool operator == (const Address& value) const NN_NOEXCEPT
    {
        for (int index = 0; index < AddressLength; ++index)
        {
            if (address[index] != value.address[index])
            {
                return false;
            }
        }
        return true;
    }

    /**
     * @brief      アドレスが一致していないかどうか比較します
     */
    bool operator != (const Address& value) const NN_NOEXCEPT
    {
        return !(*this == value);
    }
};

}}
