﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/bgtc/bgtc_Types.h>
#include <nn/bgtc/detail/bgtc_ITaskService.sfdl.h>
#include <nn/os.h>
#include <nn/sf/sf_HipcClient.h>
#include <mutex>

namespace nn { namespace bgtc { namespace detail {

    class TaskImpl
    {
    public:

        TaskImpl() NN_NOEXCEPT;
        ~TaskImpl() NN_NOEXCEPT;

        Result Initialize() NN_NOEXCEPT;
        bool IsInitialized() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        Result NotifyStarting() NN_NOEXCEPT;
        void NotifyFinished() NN_NOEXCEPT;
        nn::os::SystemEvent& GetTriggerEvent() NN_NOEXCEPT;
        bool IsInHalfAwake() NN_NOEXCEPT;
        bool IsInFullAwake();

        void Schedule(Interval intervalSeconds) NN_NOEXCEPT;
        void ScheduleUnsafe(Interval intervalSeconds) NN_NOEXCEPT;
        void SchedulePeriodic(Interval intervalSecondsFirst, Interval intervalSecondsPeriodic) NN_NOEXCEPT;
        Result GetScheduledInterval(Interval* pOutSeconds) NN_NOEXCEPT;
        Result Unschedule() NN_NOEXCEPT;
        nn::os::SystemEvent& GetScheduleEvent() NN_NOEXCEPT;

        OperationMode GetOperationMode() NN_NOEXCEPT;
        bool WillDisconnectNetworkWhenEnteringSleep() NN_NOEXCEPT;
        bool WillStayHalfAwakeInsteadSleep() NN_NOEXCEPT;

        void SetClientName(const char* pName) NN_NOEXCEPT;

    private:
        nn::os::SystemEvent m_SystemEventForTrigger;
        nn::os::SystemEvent m_SystemEventForSchedule;

        nn::sf::SharedPointer<ITaskService> m_pTaskService;

        Result AttachEventsForTaskService();
        void FinalizeEventsForTaskService();

        void SetCurrentModuleName();

        ITaskService& GetTaskService() NN_NOEXCEPT;
    };

}}}
