﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/os.h>

namespace nn{ namespace bgsu{

class MultiClientSystemEvent
{
public:
    class Node : public nn::util::IntrusiveListBaseNode<Node>, public os::SystemEvent
    {
    public:
        Node() NN_NOEXCEPT
            : SystemEvent()
        {
        }

        explicit Node(os::EventClearMode clearMode, bool interProcess) NN_NOEXCEPT
            : SystemEvent(clearMode, interProcess)
        {
        }
    };
    typedef nn::util::IntrusiveList<Node, nn::util::IntrusiveListBaseNodeTraits<Node> > List;

    MultiClientSystemEvent() NN_NOEXCEPT;

    void Attach(Node* pNode) NN_NOEXCEPT;
    void Detach(Node* pNode) NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;
    void Signal() NN_NOEXCEPT;

private:
    List        m_List;
    os::Mutex   m_Mutex;
};

}}


