﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/service/bcat_TypesService.h>
#include <nn/nn_ApplicationId.h>

namespace nn { namespace bcat { namespace service {

/*!
    @name データ復号
    @{
*/

/*!
    @brief      暗号化されたアーカイブファイルを復号します。

    @param[out] outSize     復号済みファイルのサイズ。
    @param[in]  decoded     復号済みファイルを格納するバッファ。
    @param[in]  decodedSize 復号済みファイルを格納するバッファのサイズ。
    @param[in]  encoded     暗号化されたアーカイブファイル。
    @param[in]  encodedSize 暗号化されたアーカイブファイルのサイズ。

    @return     処理結果。
    @retval     ResultPassphraseNotSaved        パスフレーズが保存されていない。
    @retval     ResultDataVerificationFailed    データの検証に失敗した。
    @retval     ResultUnsupportedFormatDetected サポートしていないフォーマットのデータを検出した。

    @pre
        - outSize != nullptr
        - decoded != nullptr
        - decodedSize > 0
        - encoded != nullptr
        - encodedSize > 0
        - appId != nn::ApplicationId::GetInvalidId()
        - passphrase != nullptr

    @details
                復号済みファイルを格納するバッファのサイズは、暗号化されたアーカイブファイルのサイズと同じにすることを推奨します。
*/
nn::Result DecodeArchiveFile(size_t* outSize, void* decoded, size_t decodedSize,
    const void* encoded, size_t encodedSize, nn::ApplicationId appId, const char* passphrase) NN_NOEXCEPT;

/*!
    @}
*/

}}}
