﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/service/bcat_Common.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

/*!
    @brief      受信したプッシュ通知のログを管理するモジュールです。
*/
class PushNotificationLogManager
{
private:
    NN_DISALLOW_COPY(PushNotificationLogManager);
    NN_DISALLOW_MOVE(PushNotificationLogManager);

private:
    /*!
        @brief      コンストラクタです。
    */
    PushNotificationLogManager() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static PushNotificationLogManager& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(PushNotificationLogManager, s_Instance);
        return s_Instance;
    }

public:
    /*!
        @brief      プッシュ通知を受信したことを通知します。

        @param[in]  topicId トピック ID。
    */
    void Notify(const TopicId& topicId) NN_NOEXCEPT;

    /*!
        @brief      受信ログリストを取得します。

        @param[out] outCount    取得した受信ログ数。
        @param[out] outLogs     受信ログリスト。
        @param[in]  count       受信ログリストの要素数。

        @pre
            - outCount != nullptr
            - outLogs != nullptr
            - count > 0
    */
    void GetList(int* outCount, PushNotificationLog* outLogs, int count) const NN_NOEXCEPT;

private:
    //
    mutable nn::os::Mutex m_Mutex;
    //
    PushNotificationLog m_Logs[PushNotificationLogCountMax];
    int m_Count;
};

}}}}}
