﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

/*!
    @brief      製品モード検査モジュールです。
*/
class ProductionMode
{
public:
    /*!
        @brief      製品モードかどうかを取得します。

        @return     製品モードかどうか。
    */
    static bool IsProduction() NN_NOEXCEPT
    {
        bool isProductionMode = true;

        if (nn::settings::fwdbg::GetSettingsItemValue(&isProductionMode, 1, "bcat", "production_mode") == 1)
        {
            return isProductionMode;
        }

        return true;
    }
};

}}}}}
