﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/service/bcat_Common.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

/*!
    @brief      パラメータ変換モジュールです。
*/
class ParameterConverter
{
public:
    /*!
        @brief      アプリケーション ID をトピック ID に変換します。

        @param[out] outTopicId  トピック ID。
        @param[in]  appId       アプリケーション ID。

        @pre
            - outTopicId != nullptr
    */
    static void Convert(TopicId* outTopicId, nn::ApplicationId appId) NN_NOEXCEPT;

    /*!
        @brief      アプリケーション ID をトピック ID に変換します。

        @param[out] outAppId    アプリケーション ID。
        @param[in]  topicId     トピック ID。

        @return     変換に成功したかどうか。

        @pre
            - outAppId != nullptr
    */
    static bool Convert(nn::ApplicationId* outAppId, const TopicId& topicId) NN_NOEXCEPT;

    /*!
        @brief      ダイジェスト値文字列をダイジェスト値に変換します。

        @param[out] outDigest   ダイジェスト値。
        @param[in]  digest      ダイジェスト値。

        @return     変換に成功したかどうか。

        @pre
            - outDigest != nullptr
            - digest != nullptr
    */
    static bool Convert(Digest* outDigest, const char* digest) NN_NOEXCEPT;

    /*!
        @brief      処理結果を整数値に変換します。

        @param[in]  result  処理結果。

        @return     整数値。
    */
    static int32_t Convert(nn::Result result) NN_NOEXCEPT;

    /*!
        @brief      整数値を処理結果に変換します。

        @param[in]  value   整数値。

        @return     処理結果。
    */
    static nn::Result Convert(int32_t value) NN_NOEXCEPT;
};

}}}}}
