﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/ipc/bcat_IServiceCreator.sfdl.h>
#include <nn/bcat/detail/service/bcat_Capability.h>

namespace nn { namespace bcat { namespace detail { namespace service {

/*!
    @brief      サービス生成器です。
*/
class ServiceCreator
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  serviceName サービス名。
        @param[in]  capability  ケイパビリティ。
    */
    ServiceCreator(const char* serviceName, const Capability& capability) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~ServiceCreator() NN_NOEXCEPT;

public:
    // IServiceCreator
    nn::Result CreateBcatService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IBcatService>> outService, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result CreateDeliveryCacheStorageService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheStorageService>> outService, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result CreateDeliveryCacheStorageServiceWithApplicationId(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheStorageService>> outService, nn::ApplicationId appId) NN_NOEXCEPT;

private:
    //
    const char* m_ServiceName;
    //
    Capability m_Capability;

private:
    //
    nn::Result CreateBcatServiceImpl(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IBcatService>> outService) NN_NOEXCEPT;
    nn::Result CreateBcatServiceImpl(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IBcatService>> outService, nn::ApplicationId appId, uint32_t appVersion) NN_NOEXCEPT;
    nn::Result CreateDeliveryCacheStorageServiceImpl(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheStorageService>> outService, nn::ApplicationId appId) NN_NOEXCEPT;
};

}}}}
