﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/ipc/bcat_IBcatService.sfdl.h>
#include <nn/bcat/detail/service/bcat_ServiceMemoryManager.h>

namespace nn { namespace bcat { namespace detail { namespace service {

/*!
    @brief      BCAT サービスです。
*/
class BcatServiceForGeneric
{
public:
    /*!
        @brief      コンストラクタです。
    */
    BcatServiceForGeneric() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~BcatServiceForGeneric() NN_NOEXCEPT;

public:
    // IBcatService
    nn::Result RequestSyncDeliveryCache(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService) NN_NOEXCEPT;
    nn::Result RequestSyncDeliveryCacheWithDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT;
    nn::Result CancelSyncDeliveryCacheRequest() NN_NOEXCEPT;
    nn::Result RequestSyncDeliveryCacheWithApplicationId(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT;
    nn::Result RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT;
    nn::Result SetPassphrase(nn::ApplicationId appId, const nn::sf::InArray<char>& passphrase) NN_NOEXCEPT;
    nn::Result RegisterBackgroundDeliveryTask(nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT;
    nn::Result UnregisterBackgroundDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result BlockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result UnblockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result EnumerateBackgroundDeliveryTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::TaskInfo>& outInfos) NN_NOEXCEPT;
    nn::Result GetDeliveryList(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& buffer, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ClearDeliveryCacheStorage(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result GetPushNotificationLog(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::PushNotificationLog>& outLogs) NN_NOEXCEPT;

private:
    //
    nn::Result CreateDeliveryCacheProgressService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService) NN_NOEXCEPT;
};

NN_STATIC_ASSERT(sizeof (BcatServiceForGeneric) <= detail::service::ServiceMemoryManager::BcatServiceSize);

}}}}
