﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace bcat { namespace detail { namespace ipc {

//// BcatService

/*!
    @brief      1 プロセスあたりの BcatService 数です。
*/
const int BcatServiceCountPerProcess = 1;

/*!
    @brief      BcatService の最大数です。

    @details
                内訳は以下のとおりです。

                - アプリケーション … 1
                - データ管理 … 1
                - 予約 … 2
*/
const int BcatServiceCountMax = 4;

//// DeliveryCacheStorageService

/*!
    @brief      1 プロセスあたりの DeliveryCacheStorageService 数です。
*/
const int DeliveryCacheStorageServiceCountPerProcess = 1;

/*!
    @brief      DeliveryCacheStorageService の最大数です。

    @details
                内訳は以下のとおりです。

                - アプリケーション … 1
                - 予約 … 1
*/
const int DeliveryCacheStorageServiceCountMax = 2;

//// DeliveryCacheFileService

/*!
    @brief      1 プロセスあたりの DeliveryCacheFileService 数です。
*/
const int DeliveryCacheFileServiceCountPerProcess = 8;

/*!
    @brief      DeliveryCacheFileService の最大数です。
*/
const int DeliveryCacheFileServiceCountMax = DeliveryCacheFileServiceCountPerProcess * DeliveryCacheStorageServiceCountMax;

//// DeliveryCacheDirectoryService

/*!
    @brief      1 プロセスあたりの DeliveryCacheDirectoryService 数です。
*/
const int DeliveryCacheDirectoryServiceCountPerProcess = 8;

/*!
    @brief      DeliveryCacheDirectoryService の最大数です。
*/
const int DeliveryCacheDirectoryServiceCountMax = DeliveryCacheDirectoryServiceCountPerProcess * DeliveryCacheStorageServiceCountMax;

//// DeliveryCacheProgressService

/*!
    @brief      1 プロセスあたりの DeliveryCacheProgressService 数です。
*/
const int DeliveryCacheProgressServiceCountPerProcess = 8;

/*!
    @brief      DeliveryCacheProgressService の最大数です。
*/
const int DeliveryCacheProgressServiceCountMax = DeliveryCacheProgressServiceCountPerProcess * BcatServiceCountMax;

//// Session

/*!
    @brief      1 プロセスあたりのセッション数です。
*/
const int SessionCountPerProcess = 2;

/*!
    @brief      システムが提供するセッション数です。
*/
const int SessionCountMax = 8;

//// Object

/*!
    @brief      1 プロセスあたりのオブジェクト数です。

    @details
                サービス生成器＋各オブジェクトの総数 になります。
*/
const int ObjectCountPerProcess = 1 +
    BcatServiceCountPerProcess +
    DeliveryCacheStorageServiceCountPerProcess +
    DeliveryCacheFileServiceCountPerProcess +
    DeliveryCacheDirectoryServiceCountPerProcess +
    DeliveryCacheProgressServiceCountPerProcess;

}}}}
