﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      audioctrl モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_AUDIOCTRL_TRACE(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_TRACE_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_TRACE_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_TRACE_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIOCTRL_INFO(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_INFO_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_INFO_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_INFO_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIOCTRL_WARN(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_WARN_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_WARN_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_WARN_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIOCTRL_ERROR(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_ERROR_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_ERROR_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_ERROR_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIOCTRL_FATAL(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_FATAL_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_FATAL_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIOCTRL_FATAL_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audioctrl, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIOCTRL_VTRACE(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Trace, 0, format, args)
#define NN_DETAIL_AUDIOCTRL_VTRACE_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Trace, 1, format, args)
#define NN_DETAIL_AUDIOCTRL_VTRACE_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Trace, 2, format, args)
#define NN_DETAIL_AUDIOCTRL_VTRACE_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Trace, 3, format, args)

#define NN_DETAIL_AUDIOCTRL_VINFO(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Info, 0, format, args)
#define NN_DETAIL_AUDIOCTRL_VINFO_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Info, 1, format, args)
#define NN_DETAIL_AUDIOCTRL_VINFO_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Info, 2, format, args)
#define NN_DETAIL_AUDIOCTRL_VINFO_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Info, 3, format, args)

#define NN_DETAIL_AUDIOCTRL_VWARN(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Warn, 0, format, args)
#define NN_DETAIL_AUDIOCTRL_VWARN_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Warn, 1, format, args)
#define NN_DETAIL_AUDIOCTRL_VWARN_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Warn, 2, format, args)
#define NN_DETAIL_AUDIOCTRL_VWARN_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Warn, 3, format, args)

#define NN_DETAIL_AUDIOCTRL_VERROR(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Error, 0, format, args)
#define NN_DETAIL_AUDIOCTRL_VERROR_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Error, 1, format, args)
#define NN_DETAIL_AUDIOCTRL_VERROR_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Error, 2, format, args)
#define NN_DETAIL_AUDIOCTRL_VERROR_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Error, 3, format, args)

#define NN_DETAIL_AUDIOCTRL_VFATAL(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Fatal, 0, format, args)
#define NN_DETAIL_AUDIOCTRL_VFATAL_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Fatal, 1, format, args)
#define NN_DETAIL_AUDIOCTRL_VFATAL_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Fatal, 2, format, args)
#define NN_DETAIL_AUDIOCTRL_VFATAL_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audioctrl, Fatal, 3, format, args)

#define NN_DETAIL_AUDIOCTRL_PUT_TRACE(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Trace, 0, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_TRACE_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Trace, 1, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_TRACE_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Trace, 2, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_TRACE_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Trace, 3, text, length)

#define NN_DETAIL_AUDIOCTRL_PUT_INFO(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Info, 0, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_INFO_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Info, 1, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_INFO_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Info, 2, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_INFO_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Info, 3, text, length)

#define NN_DETAIL_AUDIOCTRL_PUT_WARN(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Warn, 0, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_WARN_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Warn, 1, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_WARN_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Warn, 2, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_WARN_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Warn, 3, text, length)

#define NN_DETAIL_AUDIOCTRL_PUT_ERROR(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Error, 0, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_ERROR_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Error, 1, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_ERROR_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Error, 2, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_ERROR_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Error, 3, text, length)

#define NN_DETAIL_AUDIOCTRL_PUT_FATAL(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Fatal, 0, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_FATAL_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Fatal, 1, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_FATAL_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Fatal, 2, text, length)
#define NN_DETAIL_AUDIOCTRL_PUT_FATAL_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audioctrl, Fatal, 3, text, length)
