﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/audioctrl/audioctrl_PlayReport.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace audioctrl { namespace detail { // NOLINT(whitespace/braces)

class IAudioController;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAudioController, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAudioController)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTargetVolume, (::std::uint32_t target, ::nn::sf::Out<::std::int32_t> volume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetTargetVolume, (::std::uint32_t target, ::std::int32_t volume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTargetVolumeMin, (::nn::sf::Out<::std::int32_t> volume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTargetVolumeMax, (::nn::sf::Out<::std::int32_t> volume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsTargetMute, (::std::uint32_t target, ::nn::sf::Out<bool> isMute))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetTargetMute, (::std::uint32_t target, bool isMute))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsTargetConnected, (::std::uint32_t target, ::nn::sf::Out<bool> isConnected))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultTarget, (::std::uint32_t target, ::nn::TimeSpanType fadeOutTime, ::nn::TimeSpanType fadeInTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultTarget, (::nn::sf::Out<::std::int32_t> defaultTarget))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioOutputMode, (::nn::sf::Out<::std::uint32_t> mode, ::std::uint32_t target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAudioOutputMode, (::std::uint32_t target, ::std::uint32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetForceMutePolicy, (::std::int32_t policy))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetForceMutePolicy, (::nn::sf::Out<::std::int32_t> policy))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetOutputModeSetting, (::nn::sf::Out<::std::uint32_t> mode, ::std::uint32_t target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetOutputModeSetting, (::std::uint32_t target, ::std::uint32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetOutputTarget, (::std::uint32_t target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetInputTargetForceEnabled, (bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetHeadphoneOutputLevelMode, (::std::uint32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetHeadphoneOutputLevelMode, (::nn::sf::Out<::std::uint32_t> mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireAudioVolumeUpdateEventForPlayReport, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireAudioOutputDeviceUpdateEventForPlayReport, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioOutputTargetForPlayReport, (::nn::sf::Out<::std::uint32_t> target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(NotifyHeadphoneVolumeWarningDisplayedEvent)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemOutputMasterVolume, (float volume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemOutputMasterVolume, (::nn::sf::Out<float> volume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioVolumeDataForPlayReport, (::nn::sf::Out<::nn::audioctrl::PlayReportAudioVolumeData> volume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateHeadphoneSettings, (bool isRestricted))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAudioController)

        ::nn::Result GetTargetVolume(::std::uint32_t target, ::nn::sf::Out<::std::int32_t> volume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTargetVolume, (target, volume));
        }

        ::nn::Result SetTargetVolume(::std::uint32_t target, ::std::int32_t volume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetTargetVolume, (target, volume));
        }

        ::nn::Result GetTargetVolumeMin(::nn::sf::Out<::std::int32_t> volume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTargetVolumeMin, (volume));
        }

        ::nn::Result GetTargetVolumeMax(::nn::sf::Out<::std::int32_t> volume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTargetVolumeMax, (volume));
        }

        ::nn::Result IsTargetMute(::std::uint32_t target, ::nn::sf::Out<bool> isMute) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsTargetMute, (target, isMute));
        }

        ::nn::Result SetTargetMute(::std::uint32_t target, bool isMute) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetTargetMute, (target, isMute));
        }

        ::nn::Result IsTargetConnected(::std::uint32_t target, ::nn::sf::Out<bool> isConnected) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsTargetConnected, (target, isConnected));
        }

        ::nn::Result SetDefaultTarget(::std::uint32_t target, ::nn::TimeSpanType fadeOutTime, ::nn::TimeSpanType fadeInTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDefaultTarget, (target, fadeOutTime, fadeInTime));
        }

        ::nn::Result GetDefaultTarget(::nn::sf::Out<::std::int32_t> defaultTarget) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDefaultTarget, (defaultTarget));
        }

        ::nn::Result GetAudioOutputMode(::nn::sf::Out<::std::uint32_t> mode, ::std::uint32_t target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioOutputMode, (mode, target));
        }

        ::nn::Result SetAudioOutputMode(::std::uint32_t target, ::std::uint32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAudioOutputMode, (target, mode));
        }

        ::nn::Result SetForceMutePolicy(::std::int32_t policy) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetForceMutePolicy, (policy));
        }

        ::nn::Result GetForceMutePolicy(::nn::sf::Out<::std::int32_t> policy) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetForceMutePolicy, (policy));
        }

        ::nn::Result GetOutputModeSetting(::nn::sf::Out<::std::uint32_t> mode, ::std::uint32_t target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetOutputModeSetting, (mode, target));
        }

        ::nn::Result SetOutputModeSetting(::std::uint32_t target, ::std::uint32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetOutputModeSetting, (target, mode));
        }

        ::nn::Result SetOutputTarget(::std::uint32_t target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetOutputTarget, (target));
        }

        ::nn::Result SetInputTargetForceEnabled(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetInputTargetForceEnabled, (isEnabled));
        }

        ::nn::Result SetHeadphoneOutputLevelMode(::std::uint32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetHeadphoneOutputLevelMode, (mode));
        }

        ::nn::Result GetHeadphoneOutputLevelMode(::nn::sf::Out<::std::uint32_t> mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetHeadphoneOutputLevelMode, (mode));
        }

        ::nn::Result AcquireAudioVolumeUpdateEventForPlayReport(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireAudioVolumeUpdateEventForPlayReport, (handle));
        }

        ::nn::Result AcquireAudioOutputDeviceUpdateEventForPlayReport(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireAudioOutputDeviceUpdateEventForPlayReport, (handle));
        }

        ::nn::Result GetAudioOutputTargetForPlayReport(::nn::sf::Out<::std::uint32_t> target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioOutputTargetForPlayReport, (target));
        }

        ::nn::Result NotifyHeadphoneVolumeWarningDisplayedEvent() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(NotifyHeadphoneVolumeWarningDisplayedEvent);
        }

        ::nn::Result SetSystemOutputMasterVolume(float volume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSystemOutputMasterVolume, (volume));
        }

        ::nn::Result GetSystemOutputMasterVolume(::nn::sf::Out<float> volume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemOutputMasterVolume, (volume));
        }

        ::nn::Result GetAudioVolumeDataForPlayReport(::nn::sf::Out<::nn::audioctrl::PlayReportAudioVolumeData> volume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioVolumeDataForPlayReport, (volume));
        }

        ::nn::Result UpdateHeadphoneSettings(bool isRestricted) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateHeadphoneSettings, (isRestricted));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAudioController
    {
    public:
        nn::Result GetTargetVolume(std::uint32_t target, nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT;
        nn::Result SetTargetVolume(std::uint32_t target, std::int32_t volume) NN_NOEXCEPT;
        nn::Result GetTargetVolumeMin(nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT;
        nn::Result GetTargetVolumeMax(nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT;
        nn::Result IsTargetMute(std::uint32_t target, nn::sf::Out<bool> isMute) NN_NOEXCEPT;
        nn::Result SetTargetMute(std::uint32_t target, bool isMute) NN_NOEXCEPT;
        nn::Result IsTargetConnected(std::uint32_t target, nn::sf::Out<bool> isConnected) NN_NOEXCEPT;
        nn::Result SetDefaultTarget(std::uint32_t target, nn::TimeSpanType fadeOutTime, nn::TimeSpanType fadeInTime) NN_NOEXCEPT;
        nn::Result GetDefaultTarget(nn::sf::Out<std::int32_t> defaultTarget) NN_NOEXCEPT;
        nn::Result GetAudioOutputMode(nn::sf::Out<std::uint32_t> mode, std::uint32_t target) NN_NOEXCEPT;
        nn::Result SetAudioOutputMode(std::uint32_t target, std::uint32_t mode) NN_NOEXCEPT;
        nn::Result SetForceMutePolicy(std::int32_t policy) NN_NOEXCEPT;
        nn::Result GetForceMutePolicy(nn::sf::Out<std::int32_t> policy) NN_NOEXCEPT;
        nn::Result GetOutputModeSetting(nn::sf::Out<std::uint32_t> mode, std::uint32_t target) NN_NOEXCEPT;
        nn::Result SetOutputModeSetting(std::uint32_t target, std::uint32_t mode) NN_NOEXCEPT;
        nn::Result SetOutputTarget(std::uint32_t target) NN_NOEXCEPT;
        nn::Result SetInputTargetForceEnabled(bool isEnabled) NN_NOEXCEPT;
        nn::Result SetHeadphoneOutputLevelMode(std::uint32_t mode) NN_NOEXCEPT;
        nn::Result GetHeadphoneOutputLevelMode(nn::sf::Out<std::uint32_t> mode) NN_NOEXCEPT;
        nn::Result AcquireAudioVolumeUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result AcquireAudioOutputDeviceUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result GetAudioOutputTargetForPlayReport(nn::sf::Out<std::uint32_t> target) NN_NOEXCEPT;
        nn::Result NotifyHeadphoneVolumeWarningDisplayedEvent() NN_NOEXCEPT;
        nn::Result SetSystemOutputMasterVolume(float volume) NN_NOEXCEPT;
        nn::Result GetSystemOutputMasterVolume(nn::sf::Out<float> volume) NN_NOEXCEPT;
        nn::Result GetAudioVolumeDataForPlayReport(nn::sf::Out<nn::audioctrl::PlayReportAudioVolumeData> volume) NN_NOEXCEPT;
        nn::Result UpdateHeadphoneSettings(bool isRestricted) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetTargetVolume(std::uint32_t target, nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT;
    nn::Result SetTargetVolume(std::uint32_t target, std::int32_t volume) NN_NOEXCEPT;
    nn::Result GetTargetVolumeMin(nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT;
    nn::Result GetTargetVolumeMax(nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT;
    nn::Result IsTargetMute(std::uint32_t target, nn::sf::Out<bool> isMute) NN_NOEXCEPT;
    nn::Result SetTargetMute(std::uint32_t target, bool isMute) NN_NOEXCEPT;
    nn::Result IsTargetConnected(std::uint32_t target, nn::sf::Out<bool> isConnected) NN_NOEXCEPT;
    nn::Result SetDefaultTarget(std::uint32_t target, nn::TimeSpanType fadeOutTime, nn::TimeSpanType fadeInTime) NN_NOEXCEPT;
    nn::Result GetDefaultTarget(nn::sf::Out<std::int32_t> defaultTarget) NN_NOEXCEPT;
    nn::Result GetAudioOutputMode(nn::sf::Out<std::uint32_t> mode, std::uint32_t target) NN_NOEXCEPT;
    nn::Result SetAudioOutputMode(std::uint32_t target, std::uint32_t mode) NN_NOEXCEPT;
    nn::Result SetForceMutePolicy(std::int32_t policy) NN_NOEXCEPT;
    nn::Result GetForceMutePolicy(nn::sf::Out<std::int32_t> policy) NN_NOEXCEPT;
    nn::Result GetOutputModeSetting(nn::sf::Out<std::uint32_t> mode, std::uint32_t target) NN_NOEXCEPT;
    nn::Result SetOutputModeSetting(std::uint32_t target, std::uint32_t mode) NN_NOEXCEPT;
    nn::Result SetOutputTarget(std::uint32_t target) NN_NOEXCEPT;
    nn::Result SetInputTargetForceEnabled(bool isEnabled) NN_NOEXCEPT;
    nn::Result SetHeadphoneOutputLevelMode(std::uint32_t mode) NN_NOEXCEPT;
    nn::Result GetHeadphoneOutputLevelMode(nn::sf::Out<std::uint32_t> mode) NN_NOEXCEPT;
    nn::Result AcquireAudioVolumeUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result AcquireAudioOutputDeviceUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result GetAudioOutputTargetForPlayReport(nn::sf::Out<std::uint32_t> target) NN_NOEXCEPT;
    nn::Result NotifyHeadphoneVolumeWarningDisplayedEvent() NN_NOEXCEPT;
    nn::Result SetSystemOutputMasterVolume(float volume) NN_NOEXCEPT;
    nn::Result GetSystemOutputMasterVolume(nn::sf::Out<float> volume) NN_NOEXCEPT;
    nn::Result GetAudioVolumeDataForPlayReport(nn::sf::Out<nn::audioctrl::PlayReportAudioVolumeData> volume) NN_NOEXCEPT;
    nn::Result UpdateHeadphoneSettings(bool isRestricted) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::audioctrl::detail::IAudioController))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTargetVolume, (::std::uint32_t target, ::nn::sf::Out<::std::int32_t> volume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTargetVolume, (target, volume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTargetVolume, (::std::uint32_t target, ::std::int32_t volume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetTargetVolume, (target, volume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTargetVolumeMin, (::nn::sf::Out<::std::int32_t> volume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTargetVolumeMin, (volume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTargetVolumeMax, (::nn::sf::Out<::std::int32_t> volume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTargetVolumeMax, (volume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsTargetMute, (::std::uint32_t target, ::nn::sf::Out<bool> isMute))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsTargetMute, (target, isMute));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTargetMute, (::std::uint32_t target, bool isMute))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetTargetMute, (target, isMute));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsTargetConnected, (::std::uint32_t target, ::nn::sf::Out<bool> isConnected))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsTargetConnected, (target, isConnected));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultTarget, (::std::uint32_t target, ::nn::TimeSpanType fadeOutTime, ::nn::TimeSpanType fadeInTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDefaultTarget, (target, fadeOutTime, fadeInTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultTarget, (::nn::sf::Out<::std::int32_t> defaultTarget))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDefaultTarget, (defaultTarget));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioOutputMode, (::nn::sf::Out<::std::uint32_t> mode, ::std::uint32_t target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioOutputMode, (mode, target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAudioOutputMode, (::std::uint32_t target, ::std::uint32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAudioOutputMode, (target, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetForceMutePolicy, (::std::int32_t policy))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetForceMutePolicy, (policy));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetForceMutePolicy, (::nn::sf::Out<::std::int32_t> policy))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetForceMutePolicy, (policy));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOutputModeSetting, (::nn::sf::Out<::std::uint32_t> mode, ::std::uint32_t target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetOutputModeSetting, (mode, target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOutputModeSetting, (::std::uint32_t target, ::std::uint32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetOutputModeSetting, (target, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOutputTarget, (::std::uint32_t target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetOutputTarget, (target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInputTargetForceEnabled, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetInputTargetForceEnabled, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHeadphoneOutputLevelMode, (::std::uint32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetHeadphoneOutputLevelMode, (mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHeadphoneOutputLevelMode, (::nn::sf::Out<::std::uint32_t> mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetHeadphoneOutputLevelMode, (mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireAudioVolumeUpdateEventForPlayReport, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireAudioVolumeUpdateEventForPlayReport, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireAudioOutputDeviceUpdateEventForPlayReport, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireAudioOutputDeviceUpdateEventForPlayReport, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioOutputTargetForPlayReport, (::nn::sf::Out<::std::uint32_t> target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioOutputTargetForPlayReport, (target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyHeadphoneVolumeWarningDisplayedEvent)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(NotifyHeadphoneVolumeWarningDisplayedEvent);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemOutputMasterVolume, (float volume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSystemOutputMasterVolume, (volume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemOutputMasterVolume, (::nn::sf::Out<float> volume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemOutputMasterVolume, (volume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioVolumeDataForPlayReport, (::nn::sf::Out<::nn::audioctrl::PlayReportAudioVolumeData> volume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioVolumeDataForPlayReport, (volume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateHeadphoneSettings, (bool isRestricted))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateHeadphoneSettings, (isRestricted));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::audioctrl::detail::IAudioController>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::audioctrl::detail::IAudioController))

    // nn::Result GetTargetVolume(std::uint32_t target, nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTargetVolume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(volume, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTargetVolume)

    // nn::Result SetTargetVolume(std::uint32_t target, std::int32_t volume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetTargetVolume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(volume, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (target, volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetTargetVolume)

    // nn::Result GetTargetVolumeMin(nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTargetVolumeMin)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(volume, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTargetVolumeMin)

    // nn::Result GetTargetVolumeMax(nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTargetVolumeMax)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(volume, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTargetVolumeMax)

    // nn::Result IsTargetMute(std::uint32_t target, nn::sf::Out<bool> isMute) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsTargetMute)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isMute, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isMute))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isMute)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsTargetMute)

    // nn::Result SetTargetMute(std::uint32_t target, bool isMute) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetTargetMute)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isMute, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isMute, target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isMute)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetTargetMute)

    // nn::Result IsTargetConnected(std::uint32_t target, nn::sf::Out<bool> isConnected) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsTargetConnected)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isConnected, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isConnected))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isConnected)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsTargetConnected)

    // nn::Result SetDefaultTarget(std::uint32_t target, nn::TimeSpanType fadeOutTime, nn::TimeSpanType fadeInTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDefaultTarget)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fadeOutTime, (::nn::TimeSpanType), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fadeInTime, (::nn::TimeSpanType), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (target, fadeOutTime, fadeInTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fadeOutTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fadeInTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDefaultTarget)

    // nn::Result GetDefaultTarget(nn::sf::Out<std::int32_t> defaultTarget) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDefaultTarget)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(defaultTarget, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (defaultTarget))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(defaultTarget)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDefaultTarget)

    // nn::Result GetAudioOutputMode(nn::sf::Out<std::uint32_t> mode, std::uint32_t target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioOutputMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioOutputMode)

    // nn::Result SetAudioOutputMode(std::uint32_t target, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAudioOutputMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (target, mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAudioOutputMode)

    // nn::Result SetForceMutePolicy(std::int32_t policy) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetForceMutePolicy)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(policy, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (policy))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(policy)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetForceMutePolicy)

    // nn::Result GetForceMutePolicy(nn::sf::Out<std::int32_t> policy) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetForceMutePolicy)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(policy, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (policy))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(policy)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetForceMutePolicy)

    // nn::Result GetOutputModeSetting(nn::sf::Out<std::uint32_t> mode, std::uint32_t target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetOutputModeSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetOutputModeSetting)

    // nn::Result SetOutputModeSetting(std::uint32_t target, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetOutputModeSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (target, mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetOutputModeSetting)

    // nn::Result SetOutputTarget(std::uint32_t target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetOutputTarget)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetOutputTarget)

    // nn::Result SetInputTargetForceEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetInputTargetForceEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetInputTargetForceEnabled)

    // nn::Result SetHeadphoneOutputLevelMode(std::uint32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetHeadphoneOutputLevelMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetHeadphoneOutputLevelMode)

    // nn::Result GetHeadphoneOutputLevelMode(nn::sf::Out<std::uint32_t> mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetHeadphoneOutputLevelMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetHeadphoneOutputLevelMode)

    // nn::Result AcquireAudioVolumeUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireAudioVolumeUpdateEventForPlayReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireAudioVolumeUpdateEventForPlayReport)

    // nn::Result AcquireAudioOutputDeviceUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireAudioOutputDeviceUpdateEventForPlayReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireAudioOutputDeviceUpdateEventForPlayReport)

    // nn::Result GetAudioOutputTargetForPlayReport(nn::sf::Out<std::uint32_t> target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioOutputTargetForPlayReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(target, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioOutputTargetForPlayReport)

    // nn::Result NotifyHeadphoneVolumeWarningDisplayedEvent() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyHeadphoneVolumeWarningDisplayedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyHeadphoneVolumeWarningDisplayedEvent)

    // nn::Result SetSystemOutputMasterVolume(float volume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSystemOutputMasterVolume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(volume, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSystemOutputMasterVolume)

    // nn::Result GetSystemOutputMasterVolume(nn::sf::Out<float> volume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemOutputMasterVolume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(volume, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemOutputMasterVolume)

    // nn::Result GetAudioVolumeDataForPlayReport(nn::sf::Out<nn::audioctrl::PlayReportAudioVolumeData> volume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioVolumeDataForPlayReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(volume, (::nn::audioctrl::PlayReportAudioVolumeData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(7)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioVolumeDataForPlayReport)

    // nn::Result UpdateHeadphoneSettings(bool isRestricted) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateHeadphoneSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isRestricted, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isRestricted))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isRestricted)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateHeadphoneSettings)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpanType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::audioctrl::PlayReportAudioVolumeData), 7, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::audioctrl::detail::IAudioController, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::audioctrl::detail::IAudioController))

    // nn::Result GetTargetVolume(std::uint32_t target, nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTargetVolume, (::std::uint32_t target, ::nn::sf::Out<::std::int32_t> volume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTargetVolume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTargetVolume)
    }

    // nn::Result SetTargetVolume(std::uint32_t target, std::int32_t volume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTargetVolume, (::std::uint32_t target, ::std::int32_t volume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetTargetVolume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetTargetVolume)
    }

    // nn::Result GetTargetVolumeMin(nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTargetVolumeMin, (::nn::sf::Out<::std::int32_t> volume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTargetVolumeMin)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTargetVolumeMin)
    }

    // nn::Result GetTargetVolumeMax(nn::sf::Out<std::int32_t> volume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTargetVolumeMax, (::nn::sf::Out<::std::int32_t> volume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTargetVolumeMax)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTargetVolumeMax)
    }

    // nn::Result IsTargetMute(std::uint32_t target, nn::sf::Out<bool> isMute) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsTargetMute, (::std::uint32_t target, ::nn::sf::Out<bool> isMute))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsTargetMute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isMute)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsTargetMute)
    }

    // nn::Result SetTargetMute(std::uint32_t target, bool isMute) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTargetMute, (::std::uint32_t target, bool isMute))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetTargetMute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isMute)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetTargetMute)
    }

    // nn::Result IsTargetConnected(std::uint32_t target, nn::sf::Out<bool> isConnected) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsTargetConnected, (::std::uint32_t target, ::nn::sf::Out<bool> isConnected))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsTargetConnected)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isConnected)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsTargetConnected)
    }

    // nn::Result SetDefaultTarget(std::uint32_t target, nn::TimeSpanType fadeOutTime, nn::TimeSpanType fadeInTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultTarget, (::std::uint32_t target, ::nn::TimeSpanType fadeOutTime, ::nn::TimeSpanType fadeInTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDefaultTarget)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fadeOutTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fadeInTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDefaultTarget)
    }

    // nn::Result GetDefaultTarget(nn::sf::Out<std::int32_t> defaultTarget) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultTarget, (::nn::sf::Out<::std::int32_t> defaultTarget))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDefaultTarget)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(defaultTarget)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDefaultTarget)
    }

    // nn::Result GetAudioOutputMode(nn::sf::Out<std::uint32_t> mode, std::uint32_t target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioOutputMode, (::nn::sf::Out<::std::uint32_t> mode, ::std::uint32_t target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioOutputMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioOutputMode)
    }

    // nn::Result SetAudioOutputMode(std::uint32_t target, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAudioOutputMode, (::std::uint32_t target, ::std::uint32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAudioOutputMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAudioOutputMode)
    }

    // nn::Result SetForceMutePolicy(std::int32_t policy) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetForceMutePolicy, (::std::int32_t policy))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetForceMutePolicy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(policy)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetForceMutePolicy)
    }

    // nn::Result GetForceMutePolicy(nn::sf::Out<std::int32_t> policy) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetForceMutePolicy, (::nn::sf::Out<::std::int32_t> policy))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetForceMutePolicy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(policy)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetForceMutePolicy)
    }

    // nn::Result GetOutputModeSetting(nn::sf::Out<std::uint32_t> mode, std::uint32_t target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOutputModeSetting, (::nn::sf::Out<::std::uint32_t> mode, ::std::uint32_t target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetOutputModeSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetOutputModeSetting)
    }

    // nn::Result SetOutputModeSetting(std::uint32_t target, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOutputModeSetting, (::std::uint32_t target, ::std::uint32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetOutputModeSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetOutputModeSetting)
    }

    // nn::Result SetOutputTarget(std::uint32_t target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOutputTarget, (::std::uint32_t target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetOutputTarget)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetOutputTarget)
    }

    // nn::Result SetInputTargetForceEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInputTargetForceEnabled, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetInputTargetForceEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetInputTargetForceEnabled)
    }

    // nn::Result SetHeadphoneOutputLevelMode(std::uint32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHeadphoneOutputLevelMode, (::std::uint32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetHeadphoneOutputLevelMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetHeadphoneOutputLevelMode)
    }

    // nn::Result GetHeadphoneOutputLevelMode(nn::sf::Out<std::uint32_t> mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHeadphoneOutputLevelMode, (::nn::sf::Out<::std::uint32_t> mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetHeadphoneOutputLevelMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetHeadphoneOutputLevelMode)
    }

    // nn::Result AcquireAudioVolumeUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireAudioVolumeUpdateEventForPlayReport, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireAudioVolumeUpdateEventForPlayReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireAudioVolumeUpdateEventForPlayReport)
    }

    // nn::Result AcquireAudioOutputDeviceUpdateEventForPlayReport(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireAudioOutputDeviceUpdateEventForPlayReport, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireAudioOutputDeviceUpdateEventForPlayReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireAudioOutputDeviceUpdateEventForPlayReport)
    }

    // nn::Result GetAudioOutputTargetForPlayReport(nn::sf::Out<std::uint32_t> target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioOutputTargetForPlayReport, (::nn::sf::Out<::std::uint32_t> target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioOutputTargetForPlayReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioOutputTargetForPlayReport)
    }

    // nn::Result NotifyHeadphoneVolumeWarningDisplayedEvent() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyHeadphoneVolumeWarningDisplayedEvent)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyHeadphoneVolumeWarningDisplayedEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyHeadphoneVolumeWarningDisplayedEvent)
    }

    // nn::Result SetSystemOutputMasterVolume(float volume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemOutputMasterVolume, (float volume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSystemOutputMasterVolume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSystemOutputMasterVolume)
    }

    // nn::Result GetSystemOutputMasterVolume(nn::sf::Out<float> volume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemOutputMasterVolume, (::nn::sf::Out<float> volume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemOutputMasterVolume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemOutputMasterVolume)
    }

    // nn::Result GetAudioVolumeDataForPlayReport(nn::sf::Out<nn::audioctrl::PlayReportAudioVolumeData> volume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioVolumeDataForPlayReport, (::nn::sf::Out<::nn::audioctrl::PlayReportAudioVolumeData> volume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioVolumeDataForPlayReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioVolumeDataForPlayReport)
    }

    // nn::Result UpdateHeadphoneSettings(bool isRestricted) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateHeadphoneSettings, (bool isRestricted))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateHeadphoneSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isRestricted)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateHeadphoneSettings)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::audioctrl::detail::IAudioController>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::audioctrl::detail::IAudioController))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTargetVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTargetVolume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(volume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetTargetVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetTargetVolume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(volume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTargetVolumeMin)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTargetVolumeMin)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(volume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTargetVolumeMax)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTargetVolumeMax)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(volume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsTargetMute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsTargetMute)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isMute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetTargetMute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetTargetMute)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isMute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsTargetConnected)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsTargetConnected)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isConnected)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDefaultTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDefaultTarget)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fadeOutTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fadeInTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDefaultTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDefaultTarget)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(defaultTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioOutputMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioOutputMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(mode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAudioOutputMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAudioOutputMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetForceMutePolicy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetForceMutePolicy)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(policy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetForceMutePolicy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetForceMutePolicy)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(policy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetOutputModeSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetOutputModeSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(mode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetOutputModeSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetOutputModeSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetOutputTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetOutputTarget)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetInputTargetForceEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetInputTargetForceEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetHeadphoneOutputLevelMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetHeadphoneOutputLevelMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetHeadphoneOutputLevelMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetHeadphoneOutputLevelMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireAudioVolumeUpdateEventForPlayReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireAudioVolumeUpdateEventForPlayReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireAudioOutputDeviceUpdateEventForPlayReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireAudioOutputDeviceUpdateEventForPlayReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioOutputTargetForPlayReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioOutputTargetForPlayReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyHeadphoneVolumeWarningDisplayedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyHeadphoneVolumeWarningDisplayedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSystemOutputMasterVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSystemOutputMasterVolume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(volume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemOutputMasterVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemOutputMasterVolume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(volume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioVolumeDataForPlayReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioVolumeDataForPlayReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(volume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateHeadphoneSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateHeadphoneSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isRestricted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTargetVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetTargetVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTargetVolumeMin)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTargetVolumeMax)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsTargetMute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetTargetMute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsTargetConnected)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDefaultTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDefaultTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioOutputMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAudioOutputMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetForceMutePolicy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetForceMutePolicy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetOutputModeSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetOutputModeSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetOutputTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetInputTargetForceEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetHeadphoneOutputLevelMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetHeadphoneOutputLevelMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireAudioVolumeUpdateEventForPlayReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireAudioOutputDeviceUpdateEventForPlayReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioOutputTargetForPlayReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyHeadphoneVolumeWarningDisplayedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSystemOutputMasterVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemOutputMasterVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioVolumeDataForPlayReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateHeadphoneSettings)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::audioctrl::detail::IAudioController))
