﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       オーディオの入出力先コントローラに関する公開ヘッダファイルです。
 */

#pragma once

#include <nn/audioctrl/audioctrl_AudioControllerTypes.h>

namespace nn { namespace audioctrl {

/**
 * @brief       出力先を指定されたターゲットに設定します。
 * @internal
 * @brief           出力先のターゲットを指定します。
 * @param[in]       target
 * @details
 * 標準の出力先・ターゲットへの接続状態を無視して、出力先を target で指定する出力先に変更します。
 * 無効なターゲット(nn::audioctrl::AudioTarget_Invalid) が指定されるまでは、標準の出力先・ターゲットへの接続状態を無視し続けます。
 * @note
 * - 本機能は工程検査向けに用意されています。それ以外の用途で使用は禁止します。
 * @pre
 * - target は 有効な音声入出力ターゲット、もしくは nn::audioctrl::AudioTarget_Invalid
 */
void SetOutputTargetForProduction(AudioTarget target) NN_NOEXCEPT;

/**
 * @internal
 * @brief           音声入力元を強制的に有効にします。
 * @details
 * 音声入力元を強制的に有効にします。
 * @note
 * - 本機能は工程検査向けに用意されています。それ以外の用途で使用は禁止します。
 */
void SetInputTargetForceEnabledForProduction(bool isEnabled) NN_NOEXCEPT;

}}  // namespace nn::audioctrl
