﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace audio { namespace detail { // NOLINT(whitespace/braces)

class IAudioInManagerForApplet;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAudioInManagerForApplet, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAudioInManagerForApplet)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSuspend, (::nn::applet::AppletResourceUserId id, ::std::int64_t fadeTimeNanoSeconds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestResume, (::nn::applet::AppletResourceUserId id, ::std::int64_t fadeTimeNanoSeconds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessMasterVolume, (::nn::sf::Out<float> pOutVolume, ::nn::applet::AppletResourceUserId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetProcessMasterVolume, (::nn::applet::AppletResourceUserId id, float volume, ::std::int64_t fadeTimeNanoSeconds))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAudioInManagerForApplet)

        ::nn::Result RequestSuspend(::nn::applet::AppletResourceUserId id, ::std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSuspend, (id, fadeTimeNanoSeconds));
        }

        ::nn::Result RequestResume(::nn::applet::AppletResourceUserId id, ::std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestResume, (id, fadeTimeNanoSeconds));
        }

        ::nn::Result GetProcessMasterVolume(::nn::sf::Out<float> pOutVolume, ::nn::applet::AppletResourceUserId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProcessMasterVolume, (pOutVolume, id));
        }

        ::nn::Result SetProcessMasterVolume(::nn::applet::AppletResourceUserId id, float volume, ::std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetProcessMasterVolume, (id, volume, fadeTimeNanoSeconds));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAudioInManagerForApplet
    {
    public:
        nn::Result RequestSuspend(nn::applet::AppletResourceUserId id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
        nn::Result RequestResume(nn::applet::AppletResourceUserId id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
        nn::Result GetProcessMasterVolume(nn::sf::Out<float> pOutVolume, nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
        nn::Result SetProcessMasterVolume(nn::applet::AppletResourceUserId id, float volume, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result RequestSuspend(nn::applet::AppletResourceUserId id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
    nn::Result RequestResume(nn::applet::AppletResourceUserId id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
    nn::Result GetProcessMasterVolume(nn::sf::Out<float> pOutVolume, nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
    nn::Result SetProcessMasterVolume(nn::applet::AppletResourceUserId id, float volume, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::audio::detail::IAudioInManagerForApplet))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSuspend, (::nn::applet::AppletResourceUserId id, ::std::int64_t fadeTimeNanoSeconds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSuspend, (id, fadeTimeNanoSeconds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestResume, (::nn::applet::AppletResourceUserId id, ::std::int64_t fadeTimeNanoSeconds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestResume, (id, fadeTimeNanoSeconds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessMasterVolume, (::nn::sf::Out<float> pOutVolume, ::nn::applet::AppletResourceUserId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProcessMasterVolume, (pOutVolume, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetProcessMasterVolume, (::nn::applet::AppletResourceUserId id, float volume, ::std::int64_t fadeTimeNanoSeconds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetProcessMasterVolume, (id, volume, fadeTimeNanoSeconds));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::audio::detail::IAudioInManagerForApplet>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::audio::detail::IAudioInManagerForApplet))

    // nn::Result RequestSuspend(nn::applet::AppletResourceUserId id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSuspend)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fadeTimeNanoSeconds, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, fadeTimeNanoSeconds))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fadeTimeNanoSeconds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSuspend)

    // nn::Result RequestResume(nn::applet::AppletResourceUserId id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestResume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fadeTimeNanoSeconds, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, fadeTimeNanoSeconds))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fadeTimeNanoSeconds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestResume)

    // nn::Result GetProcessMasterVolume(nn::sf::Out<float> pOutVolume, nn::applet::AppletResourceUserId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProcessMasterVolume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutVolume, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutVolume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutVolume), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProcessMasterVolume)

    // nn::Result SetProcessMasterVolume(nn::applet::AppletResourceUserId id, float volume, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetProcessMasterVolume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(volume, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::applet::AppletResourceUserId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fadeTimeNanoSeconds, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (volume, id, fadeTimeNanoSeconds))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fadeTimeNanoSeconds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetProcessMasterVolume)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::audio::detail::IAudioInManagerForApplet, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::audio::detail::IAudioInManagerForApplet))

    // nn::Result RequestSuspend(nn::applet::AppletResourceUserId id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSuspend, (::nn::applet::AppletResourceUserId id, ::std::int64_t fadeTimeNanoSeconds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSuspend)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fadeTimeNanoSeconds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSuspend)
    }

    // nn::Result RequestResume(nn::applet::AppletResourceUserId id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestResume, (::nn::applet::AppletResourceUserId id, ::std::int64_t fadeTimeNanoSeconds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestResume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fadeTimeNanoSeconds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestResume)
    }

    // nn::Result GetProcessMasterVolume(nn::sf::Out<float> pOutVolume, nn::applet::AppletResourceUserId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessMasterVolume, (::nn::sf::Out<float> pOutVolume, ::nn::applet::AppletResourceUserId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProcessMasterVolume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutVolume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProcessMasterVolume)
    }

    // nn::Result SetProcessMasterVolume(nn::applet::AppletResourceUserId id, float volume, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetProcessMasterVolume, (::nn::applet::AppletResourceUserId id, float volume, ::std::int64_t fadeTimeNanoSeconds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetProcessMasterVolume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fadeTimeNanoSeconds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetProcessMasterVolume)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::audio::detail::IAudioInManagerForApplet>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::audio::detail::IAudioInManagerForApplet))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSuspend)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSuspend)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fadeTimeNanoSeconds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestResume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestResume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fadeTimeNanoSeconds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProcessMasterVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProcessMasterVolume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutVolume),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetProcessMasterVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetProcessMasterVolume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(volume),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fadeTimeNanoSeconds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSuspend)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestResume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProcessMasterVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetProcessMasterVolume)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::audio::detail::IAudioInManagerForApplet))
