﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>
#include <cstddef>
#include <nn/nn_Macro.h>

namespace nn { namespace audio {

typedef struct DspProfilerHeader
{
    int64_t sampleFrequency; //usec
    int32_t maxSamples; //including header.
    int32_t curSample; //current sample to write
} DspProfilerHeader;

typedef struct DspProfilerParameter
{
    int64_t sampleFrequencyUsec;
    void* buffer;
    int32_t numSamples;
} DspProfilerParameter;

typedef struct DspProfilerSample
{
    int32_t timestamp;
    int32_t pc;
    int32_t thread;
} DspProfilerSample;

void StartDspProfiler(DspProfilerParameter* params) NN_NOEXCEPT;
void StopDspProfiler() NN_NOEXCEPT;

uint32_t GetBufferSizeForDspProfiler(DspProfilerParameter* params) NN_NOEXCEPT;

void StartCpuProfiler() NN_NOEXCEPT;
void StopCpuProfiler() NN_NOEXCEPT;

}} //nn::audio
