﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_StaticAssert.h>
#include <nn/audio/audio_PerformanceMetricsTypes.h>

namespace nn { namespace audio {

/**
 * @brief システム内部の詳細なパフォーマンス情報の種類を表す列挙型です。
 */
enum PerformanceSysDetailType
{
    PerformanceSysDetailType_Invalid = PerformanceDetailType_Count + 1,
    PerformanceSysDetailType_PcmInt16DataSource,
    PerformanceSysDetailType_AdpcmDataSource,
    PerformanceSysDetailType_Volume,
    PerformanceSysDetailType_VolumeRamp,
    PerformanceSysDetailType_BiquadFilter,
    PerformanceSysDetailType_Mix,
    PerformanceSysDetailType_MixRamp,
    PerformanceSysDetailType_MixRampGrouped,
    PerformanceSysDetailType_DepopPrepare,
    PerformanceSysDetailType_DepopForMixBuffers,
    PerformanceSysDetailType_Delay,
    PerformanceSysDetailType_Upsample,
    PerformanceSysDetailType_DownMix6chTo2ch,
    PerformanceSysDetailType_Aux,
    PerformanceSysDetailType_DeviceSink,
    PerformanceSysDetailType_CircularBufferSink,
    PerformanceSysDetailType_Reverb,
    PerformanceSysDetailType_I3dl2Reverb,
    PerformanceSysDetailType_Performance,
    PerformanceSysDetailType_ClearMixBuffer,
    PerformanceSysDetailType_CopyMixBuffer,
};


#pragma pack(1)

/**
 * @brief 各 VoiceType / SubMixType / FinalMixType に紐づくシステム内部の詳細なパフォーマンス情報です。
 * @details
 * ボイスドロップ処理に用いる処理の予想時間がある以外は PerfromanceDetail と同等です。
 */
struct PerformanceSysDetail
{
    NodeId parentId;                    //!< 本処理が紐づく VoiceType / SubMixType / FinalMixType の ID
    int32_t startTime;                  //!< 各オーディオフレームの処理開始を起点とした処理開始時間 [MicroSeconds]
    int32_t processingTime;             //!< 処理にかかった時間 [MicroSeconds]
    int8_t detailType;                  //!< この詳細なパフォーマンス情報の対象の種類 (nn::audio::PerformanceDetailType を保持)
    int8_t parentEntryType;             //!< 本処理が紐づく VoiceType / SubMixType / FinalMixType の種類 (nn::audio::PerformanceEntryType を保持)
    int8_t _padding0[2];
    uint32_t estimatedProcessingTime;   //!< ボイスドロップ処理に用いる処理の予想時間 [ADSP Cycles]
    int8_t _padding1[4];
};

NN_STATIC_ASSERT(sizeof(PerformanceSysDetail) == sizeof(PerformanceDetail));

#pragma pack()

}} // namespace nn::audio
