﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/applet/applet_Types.h>
#include <nn/audio/audio_Result.h>

namespace nn {
namespace audio {

/**
 * @brief       指定した applet に紐づくすべての AudioIn インスタンスを一時停止します。
 * @param[in]   id                      applet 識別子
 * @retresult
 * @handleresult{nn::audio::ResultAppletResourceUserIdNotFound}
 * @endretresult
 * @detail
 * 本関数はデバッガで applet が停止した際に呼ばれることを想定したものです。それ以外の用途に利用することはできません。
 *
 * 本関数は再帰的に呼び出すことはできません。
 */
nn::Result RequestSuspendAudioInsForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT;

/**
 * @brief       指定した applet に紐づくすべての AudioIn インスタンスを再開します。
 * @param[in]   id                      applet 識別子
 * @retresult
 * @handleresult{nn::audio::ResultAppletResourceUserIdNotFound}
 * @endretresult
 * @detail
 * 本関数はデバッガで applet が停止した際に呼ばれることを想定したものです。それ以外の用途に利用することはできません。
 */
nn::Result RequestResumeAudioInsForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT;

/**
 * @brief       指定した applet に紐づくすべての AudioOut インスタンスを一時停止します。
 * @param[in]   id                      applet 識別子
 * @retresult
 * @handleresult{nn::audio::ResultAppletResourceUserIdNotFound}
 * @endretresult
 * @detail
 * 本関数はデバッガで applet が停止した際に呼ばれることを想定したものです。それ以外の用途に利用することはできません。
 *
 * 本関数は再帰的に呼び出すことはできません。
 */
nn::Result RequestSuspendAudioOutsForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT;

/**
 * @brief       指定した applet に紐づくすべての AudioOut インスタンスを再開します。
 * @param[in]   id                      applet 識別子
 * @retresult
 * @handleresult{nn::audio::ResultAppletResourceUserIdNotFound}
 * @endretresult
 * @detail
 * 本関数はデバッガで applet が停止した際に呼ばれることを想定したものです。それ以外の用途に利用することはできません。
 */
nn::Result RequestResumeAudioOutsForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT;

/**
 * @brief       指定した applet に紐づくすべての AudioRenderer インスタンスを一時停止します。
 * @param[in]   id                      applet 識別子
 * @retresult
 * @handleresult{nn::audio::ResultAppletResourceUserIdNotFound}
 * @endretresult
 * @detail
 * 本関数はデバッガで applet が停止した際に呼ばれることを想定したものです。それ以外の用途に利用することはできません。
 *
 * 本関数は再帰的に呼び出すことはできません。
 */
nn::Result RequestSuspendAudioRenderersForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT;

/**
 * @brief       指定した applet に紐づくすべての AudioRenderer インスタンスを再開します。
 * @param[in]   id                      applet 識別子
 * @retresult
 * @handleresult{nn::audio::ResultAppletResourceUserIdNotFound}
 * @endretresult
 * @detail
 * 本関数はデバッガで applet が停止した際に呼ばれることを想定したものです。それ以外の用途に利用することはできません。
 */
nn::Result RequestResumeAudioRenderersForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT;

}  // namespace audio
}  // namespace nn

