﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace audio {

/**
 * @name オーディオ出力
 * @{
 */

/**
 * @brief       オーディオ出力の最大同時接続数を設定します。
 * @pre
 * - countMax >= 0 && countMax <= nn::audio::AudioOutCountMaxForLibraryApplet
 * - オーディオ出力機能を使用していない
 * @post
 * - GetAudioOutCountMaxForLibraryApplet() == countMax
 * @details
 * オーディオ出力の最大同時接続数を設定する LibraryApplet 向け API です。@n
 * 設定しない場合のデフォルト値は nn::audio::AudioOutCountMax です。@n
 * @n
 * 本 API はオーディオ出力機能を使用する前に一度だけ呼び出してください。
 */
void SetAudioOutCountMaxForLibraryApplet(int countMax) NN_NOEXCEPT;

/**
 * @brief       オーディオ出力の最大同時接続数を取得します。
 * @details
 * オーディオ出力の最大同時接続数を取得する LibraryApplet 向け API です。
 */
int GetAudioOutCountMaxForLibraryApplet() NN_NOEXCEPT;

/**
 * @}
 */

}}  // namespace nn::audio
