﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/arp/arp_Types.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/os/os_Types.h>

namespace nn {
namespace arp {
namespace detail {

void LogRegistration(const os::ProcessId& pid, const ApplicationLaunchProperty& launchProp, const ns::ApplicationControlProperty& ctrlProp) NN_NOEXCEPT;

int ApplicationLaunchPropertyToString(char* buffer, size_t bufferSize, const ApplicationLaunchProperty& launchProp) NN_NOEXCEPT;
int ApplicationControlPropertyToString(char* buffer, size_t bufferSize, const ns::ApplicationControlProperty& ctrlProp) NN_NOEXCEPT;

} // ~namespace nn::arp::detail
}
}
