﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   アプレットマネージャが提供する機能に関するヘッダファイル
 */

#pragma once

/**
 * @namespace   nn::applet
 *
 * @brief   アプレットマネージャが提供する機能に関する名前空間です。
 *
 * @details
 *  nn::applet の名前空間には、以下のライブラリ開発者にとって必要な
 *  アプレットマネージャが提供する機能が収められています。
 *
 *  - nn::ae のライブラリ開発者
 *  - nn::oe のライブラリ開発者
 *  - 各種ライブラリアプレットの shim ライブラリ開発者
 *
 *  ライブラリアプレットの本体は nn::ae にある機能を使用する必要がありますが、
 *  そのライブラリアプレットを呼び出す部分（呼び出し元プロセスにリンク
 *  される部分）は、nn::applet にある機能を使って開発する必要があります。
 *
 */

#include <nn/applet/applet_Types.h>
#include <nn/applet/applet_Apis.h>
#include <nn/applet/applet_LibraryApplet.h>
#include <nn/applet/applet_ApplicationSelf.h>
#include <nn/applet/applet_ApplicationControlForQuest.h>
#include <nn/applet/applet_AppletSystem.h>
#include <nn/applet/applet_IdlePolicyApi.h>
#include <nn/applet/applet_Result.h>

