﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief APM サーバライブラリでのみ使用する型の定義。
 */

#pragma once

namespace nn { namespace apm { namespace server {

/**
 * @brief @ref nn::apm::server::GetEventForUpdate で指定可能なイベントの識別子です。
 */
enum EventTarget
{
    EventTarget_Invalid = -1,
};

/**
 * @brief @ref nn::apm::server::SetBasePerformanceConfiguration で指定可能な APM サーバライブラリの基礎性能の識別子です。
 *
 * @detail @ref nn::apm::server::SetBasePerformanceConfiguration で指定可能な APM サーバライブラリの基礎性能の識別子です。@n
 *         基礎性能は @ref nn::apm::SetPerformanceConfiguration で設定可能な性能の上流に位置する設定です。@n
 *         基礎性能が @ref nn::apm::BasePerformanceConfiguration_Application の場合のみ、
 */
enum BasePerformanceConfiguration
{
    BasePerformanceConfiguration_Invalid = -1, //<! 無効な基礎性能識別子です。
    BasePerformanceConfiguration_Application,  //<! アプリケーションの要求した性能になることを表す基礎性能識別子です。
    BasePerformanceConfiguration_Background,   //<! アプリケーションの要求に依らず、バックグラウンドタスク向けに静的な性能を設定することを表す基礎性能識別子です。
};

}}} // namespace nn::apm::server
