﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief APM サーバライブラリで使用するコンフィグレーションの定数
 */

#pragma once

#include <nn/apm/server/apm_Types.h>

namespace nn { namespace apm { namespace server { namespace {

const ConfigurationEntry ConfigurationTable[] =
{
    { PerformanceConfiguration_Cpu1020MhzGpu384Mhz,           1020000000, 1020000000, 384000000, 384000000, 1600000000, 1600000000, false },
    { PerformanceConfiguration_Cpu1020MhzGpu768Mhz,           1020000000, 1020000000, 768000000, 768000000, 1600000000, 1600000000, true  },
    { PerformanceConfiguration_Cpu1224MhzGpu691Mhz,           1224000000, 1224000000, 691200000, 691200000, 1600000000, 1600000000, true  },
    { PerformanceConfiguration_Cpu1020MhzGpu230Mhz,           1020000000, 1020000000, 230400000, 230400000, 1600000000, 1600000000, false },
    { PerformanceConfiguration_Cpu1020MhzGpu307Mhz,           1020000000, 1020000000, 307200000, 307200000, 1600000000, 1600000000, false },
    { PerformanceConfiguration_Cpu1224MhzGpu230Mhz,           1224000000, 1224000000, 230400000, 230400000, 1600000000, 1600000000, false },
    { PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1331Mhz, 1020000000, 1020000000, 307200000, 307200000, 1331200000, 1331200000, false },
    { PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1331Mhz, 1020000000, 1020000000, 384000000, 384000000, 1331200000, 1331200000, false },
    { PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1065Mhz, 1020000000, 1020000000, 307200000, 307200000, 1065600000, 1065600000, false },
    { PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1065Mhz, 1020000000, 1020000000, 384000000, 384000000, 1065600000, 1065600000, false },
    { PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1600Mhz, 1020000000, 1020000000, 460800000, 460800000, 1600000000, 1600000000, false },
    { PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331Mhz, 1020000000, 1020000000, 460800000, 460800000, 1331200000, 1331200000, false },
};

const PerformanceConfiguration DefaultPerformanceConfigurationForNormalMode = PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1331Mhz;
const PerformanceConfiguration DefaultPerformanceConfigurationForBoostMode  = PerformanceConfiguration_Cpu1020MhzGpu768Mhz;

}}}} // namespace nn::apm::server::<unnamed>
