﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief APM ライブラリのシステム開発者向け機能の初期化関連 API 宣言。
 */

#pragma once

namespace nn { namespace apm {

/**
 * @brief       APM ライブラリのシステム開発者向けの機能を初期化します。
 *
 * @post        システム開発者向けの機能は初期化済の状態になります。
 *
 * @details     APM ライブラリのシステム開発者向けの機能を初期化します。@n
 *              本関数の呼び出し回数はライブラリ内部でカウントされます。
 */
void InitializeForSystem() NN_NOEXCEPT;

/**
 * @brief       APM ライブラリのシステム開発者向けの機能を未初期化状態にします。
 *
 * @post        システム開発者向けの機能は初期化前の状態になります。
 *
 * @details     APM ライブラリのシステム開発者向けの機能を未初期化状態にします。@n
 *              初期化を行った回数分、本関数が呼ばれた場合にのみ、初期化前の状態になります。
 */
void FinalizeForSystem() NN_NOEXCEPT;

}} // namepsace nn::apm
