﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief APM ライブラリのマネージャの実装クラス。
 */

#pragma once

#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nn/os.h>

#include <nn/apm/apm_IManager.sfdl.h>
#include <nn/apm/apm_IManagerPrivileged.sfdl.h>

namespace nn { namespace apm {

// IManager 実装クラス
class ManagerImpl : public nn::sf::ISharedObject
{
public:
    ManagerImpl() NN_NOEXCEPT;
    ~ManagerImpl() NN_NOEXCEPT;
    nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::apm::ISession>> pOutSession) NN_NOEXCEPT;
    nn::Result GetPerformanceMode(nn::sf::Out<nn::apm::PerformanceMode> pOutPerformanceMode) NN_NOEXCEPT;

private:
    // OpenSession / OpenSessionForDev 用アロケータとして、
    // stateful な nn::sf::ExpHeapAllocator を使用する。
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    std::aligned_storage<4 * 1024>::type m_HeapBuffer;

    nn::lmem::HeapHandle m_HeapHandle;
};

// IManagerPrivileged 実装クラス
class ManagerPrivilegedImpl : public nn::sf::ISharedObject
{
public:
    ManagerPrivilegedImpl() NN_NOEXCEPT;
    ~ManagerPrivilegedImpl() NN_NOEXCEPT;
    nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::apm::ISession>> pOutSession) NN_NOEXCEPT;

private:
    // OpenSession / OpenSessionForDev 用アロケータとして、
    // stateful な nn::sf::ExpHeapAllocator を使用する。
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    std::aligned_storage<4 * 1024>::type m_HeapBuffer;

    nn::lmem::HeapHandle m_HeapHandle;
};

}} // namespace nn::apm
