﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/aoc/aoc_Types.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace aocsrv { namespace detail { // NOLINT(whitespace/braces)

class IAddOnContentManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAddOnContentManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAddOnContentManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountAddOnContentByApplicationId, (::nn::sf::Out<::std::int32_t> outCount, ::nn::ncm::ApplicationId targetApplication))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAddOnContentByApplicationId, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>& outIndices, ::std::int32_t offset, ::std::int32_t count, ::nn::ncm::ApplicationId targetApplication))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountAddOnContent, (::nn::sf::Out<::std::int32_t> outCount, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAddOnContent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>& outIndices, ::nn::Bit64 processId, ::std::int32_t offset, ::std::int32_t count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAddOnContentBaseIdByApplicationId, (::nn::sf::Out<::nn::Bit64> outValue, ::nn::ncm::ApplicationId targetApplication))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAddOnContentBaseId, (::nn::sf::Out<::nn::Bit64> outValue, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PrepareAddOnContentByApplicationId, (::nn::aoc::AddOnContentIndex targetIndex, ::nn::ncm::ApplicationId targetApplication))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PrepareAddOnContent, (::nn::aoc::AddOnContentIndex targetIndex, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAddOnContentListChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAddOnContentManager)

        ::nn::Result CountAddOnContentByApplicationId(::nn::sf::Out<::std::int32_t> outCount, ::nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountAddOnContentByApplicationId, (outCount, targetApplication));
        }

        ::nn::Result ListAddOnContentByApplicationId(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>& outIndices, ::std::int32_t offset, ::std::int32_t count, ::nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAddOnContentByApplicationId, (outCount, outIndices, offset, count, targetApplication));
        }

        ::nn::Result CountAddOnContent(::nn::sf::Out<::std::int32_t> outCount, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountAddOnContent, (outCount, processId));
        }

        ::nn::Result ListAddOnContent(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>& outIndices, ::nn::Bit64 processId, ::std::int32_t offset, ::std::int32_t count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAddOnContent, (outCount, outIndices, processId, offset, count));
        }

        ::nn::Result GetAddOnContentBaseIdByApplicationId(::nn::sf::Out<::nn::Bit64> outValue, ::nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAddOnContentBaseIdByApplicationId, (outValue, targetApplication));
        }

        ::nn::Result GetAddOnContentBaseId(::nn::sf::Out<::nn::Bit64> outValue, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAddOnContentBaseId, (outValue, processId));
        }

        ::nn::Result PrepareAddOnContentByApplicationId(::nn::aoc::AddOnContentIndex targetIndex, ::nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PrepareAddOnContentByApplicationId, (targetIndex, targetApplication));
        }

        ::nn::Result PrepareAddOnContent(::nn::aoc::AddOnContentIndex targetIndex, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PrepareAddOnContent, (targetIndex, processId));
        }

        ::nn::Result GetAddOnContentListChangedEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAddOnContentListChangedEvent, (outHandle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAddOnContentManager
    {
    public:
        nn::Result CountAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
        nn::Result ListAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, std::int32_t offset, std::int32_t count, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
        nn::Result CountAddOnContent(nn::sf::Out<std::int32_t> outCount, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result ListAddOnContent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, nn::Bit64 processId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT;
        nn::Result GetAddOnContentBaseIdByApplicationId(nn::sf::Out<nn::Bit64> outValue, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
        nn::Result GetAddOnContentBaseId(nn::sf::Out<nn::Bit64> outValue, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result PrepareAddOnContentByApplicationId(nn::aoc::AddOnContentIndex targetIndex, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
        nn::Result PrepareAddOnContent(nn::aoc::AddOnContentIndex targetIndex, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetAddOnContentListChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CountAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
    nn::Result ListAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, std::int32_t offset, std::int32_t count, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
    nn::Result CountAddOnContent(nn::sf::Out<std::int32_t> outCount, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result ListAddOnContent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, nn::Bit64 processId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT;
    nn::Result GetAddOnContentBaseIdByApplicationId(nn::sf::Out<nn::Bit64> outValue, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
    nn::Result GetAddOnContentBaseId(nn::sf::Out<nn::Bit64> outValue, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result PrepareAddOnContentByApplicationId(nn::aoc::AddOnContentIndex targetIndex, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT;
    nn::Result PrepareAddOnContent(nn::aoc::AddOnContentIndex targetIndex, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetAddOnContentListChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::aocsrv::detail::IAddOnContentManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountAddOnContentByApplicationId, (::nn::sf::Out<::std::int32_t> outCount, ::nn::ncm::ApplicationId targetApplication))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountAddOnContentByApplicationId, (outCount, targetApplication));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAddOnContentByApplicationId, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>& outIndices, ::std::int32_t offset, ::std::int32_t count, ::nn::ncm::ApplicationId targetApplication))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAddOnContentByApplicationId, (outCount, outIndices, offset, count, targetApplication));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountAddOnContent, (::nn::sf::Out<::std::int32_t> outCount, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountAddOnContent, (outCount, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAddOnContent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>& outIndices, ::nn::Bit64 processId, ::std::int32_t offset, ::std::int32_t count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAddOnContent, (outCount, outIndices, processId, offset, count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddOnContentBaseIdByApplicationId, (::nn::sf::Out<::nn::Bit64> outValue, ::nn::ncm::ApplicationId targetApplication))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAddOnContentBaseIdByApplicationId, (outValue, targetApplication));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddOnContentBaseId, (::nn::sf::Out<::nn::Bit64> outValue, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAddOnContentBaseId, (outValue, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareAddOnContentByApplicationId, (::nn::aoc::AddOnContentIndex targetIndex, ::nn::ncm::ApplicationId targetApplication))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PrepareAddOnContentByApplicationId, (targetIndex, targetApplication));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareAddOnContent, (::nn::aoc::AddOnContentIndex targetIndex, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PrepareAddOnContent, (targetIndex, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddOnContentListChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAddOnContentListChangedEvent, (outHandle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::aocsrv::detail::IAddOnContentManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::aocsrv::detail::IAddOnContentManager))

    // nn::Result CountAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountAddOnContentByApplicationId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(targetApplication, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (targetApplication))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(targetApplication)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountAddOnContentByApplicationId)

    // nn::Result ListAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, std::int32_t offset, std::int32_t count, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAddOnContentByApplicationId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outIndices, 0, (const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outIndices))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(count, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(targetApplication, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (offset, count, targetApplication))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIndices), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(targetApplication)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAddOnContentByApplicationId)

    // nn::Result CountAddOnContent(nn::sf::Out<std::int32_t> outCount, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountAddOnContent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountAddOnContent)

    // nn::Result ListAddOnContent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, nn::Bit64 processId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAddOnContent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outIndices, 0, (const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outIndices))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(count, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (offset, count, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIndices), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAddOnContent)

    // nn::Result GetAddOnContentBaseIdByApplicationId(nn::sf::Out<nn::Bit64> outValue, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAddOnContentBaseIdByApplicationId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(targetApplication, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (targetApplication))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(targetApplication)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAddOnContentBaseIdByApplicationId)

    // nn::Result GetAddOnContentBaseId(nn::sf::Out<nn::Bit64> outValue, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAddOnContentBaseId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAddOnContentBaseId)

    // nn::Result PrepareAddOnContentByApplicationId(nn::aoc::AddOnContentIndex targetIndex, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareAddOnContentByApplicationId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(targetIndex, (::nn::aoc::AddOnContentIndex), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(targetApplication, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (targetIndex, targetApplication))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(targetIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(targetApplication)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareAddOnContentByApplicationId)

    // nn::Result PrepareAddOnContent(nn::aoc::AddOnContentIndex targetIndex, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareAddOnContent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(targetIndex, (::nn::aoc::AddOnContentIndex), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (targetIndex, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(targetIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareAddOnContent)

    // nn::Result GetAddOnContentListChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAddOnContentListChangedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAddOnContentListChangedEvent)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::aoc::AddOnContentIndex), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::aocsrv::detail::IAddOnContentManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::aocsrv::detail::IAddOnContentManager))

    // nn::Result CountAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountAddOnContentByApplicationId, (::nn::sf::Out<::std::int32_t> outCount, ::nn::ncm::ApplicationId targetApplication))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountAddOnContentByApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(targetApplication)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountAddOnContentByApplicationId)
    }

    // nn::Result ListAddOnContentByApplicationId(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, std::int32_t offset, std::int32_t count, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAddOnContentByApplicationId, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>& outIndices, ::std::int32_t offset, ::std::int32_t count, ::nn::ncm::ApplicationId targetApplication))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAddOnContentByApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIndices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(targetApplication)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAddOnContentByApplicationId)
    }

    // nn::Result CountAddOnContent(nn::sf::Out<std::int32_t> outCount, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountAddOnContent, (::nn::sf::Out<::std::int32_t> outCount, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountAddOnContent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountAddOnContent)
    }

    // nn::Result ListAddOnContent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::aoc::AddOnContentIndex>& outIndices, nn::Bit64 processId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAddOnContent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::aoc::AddOnContentIndex>& outIndices, ::nn::Bit64 processId, ::std::int32_t offset, ::std::int32_t count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAddOnContent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIndices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAddOnContent)
    }

    // nn::Result GetAddOnContentBaseIdByApplicationId(nn::sf::Out<nn::Bit64> outValue, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddOnContentBaseIdByApplicationId, (::nn::sf::Out<::nn::Bit64> outValue, ::nn::ncm::ApplicationId targetApplication))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAddOnContentBaseIdByApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(targetApplication)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAddOnContentBaseIdByApplicationId)
    }

    // nn::Result GetAddOnContentBaseId(nn::sf::Out<nn::Bit64> outValue, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddOnContentBaseId, (::nn::sf::Out<::nn::Bit64> outValue, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAddOnContentBaseId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAddOnContentBaseId)
    }

    // nn::Result PrepareAddOnContentByApplicationId(nn::aoc::AddOnContentIndex targetIndex, nn::ncm::ApplicationId targetApplication) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareAddOnContentByApplicationId, (::nn::aoc::AddOnContentIndex targetIndex, ::nn::ncm::ApplicationId targetApplication))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareAddOnContentByApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(targetIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(targetApplication)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareAddOnContentByApplicationId)
    }

    // nn::Result PrepareAddOnContent(nn::aoc::AddOnContentIndex targetIndex, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareAddOnContent, (::nn::aoc::AddOnContentIndex targetIndex, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareAddOnContent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(targetIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareAddOnContent)
    }

    // nn::Result GetAddOnContentListChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddOnContentListChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAddOnContentListChangedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAddOnContentListChangedEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::aocsrv::detail::IAddOnContentManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::aocsrv::detail::IAddOnContentManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountAddOnContentByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountAddOnContentByApplicationId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(targetApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAddOnContentByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outIndices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAddOnContentByApplicationId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outIndices),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(count),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(targetApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountAddOnContent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outIndices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAddOnContent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outIndices),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAddOnContentBaseIdByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAddOnContentBaseIdByApplicationId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(targetApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAddOnContentBaseId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAddOnContentBaseId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareAddOnContentByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareAddOnContentByApplicationId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(targetIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(targetApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareAddOnContent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(targetIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAddOnContentListChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAddOnContentListChangedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountAddOnContentByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAddOnContentByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAddOnContentBaseIdByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAddOnContentBaseId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareAddOnContentByApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAddOnContentListChangedEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::aocsrv::detail::IAddOnContentManager))
