﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      aoc モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_AOC_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_AOC_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_AOC_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_AOC_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_AOC_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_AOC_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_AOC_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_AOC_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_AOC_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_AOC_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_AOC_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_AOC_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_AOC_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_AOC_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_AOC_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_AOC_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_AOC_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_AOC_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_AOC_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_AOC_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(aoc, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_AOC_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Trace, 0, format, args)
#define NN_DETAIL_AOC_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Trace, 1, format, args)
#define NN_DETAIL_AOC_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Trace, 2, format, args)
#define NN_DETAIL_AOC_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Trace, 3, format, args)

#define NN_DETAIL_AOC_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Info, 0, format, args)
#define NN_DETAIL_AOC_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Info, 1, format, args)
#define NN_DETAIL_AOC_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Info, 2, format, args)
#define NN_DETAIL_AOC_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Info, 3, format, args)

#define NN_DETAIL_AOC_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Warn, 0, format, args)
#define NN_DETAIL_AOC_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Warn, 1, format, args)
#define NN_DETAIL_AOC_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Warn, 2, format, args)
#define NN_DETAIL_AOC_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Warn, 3, format, args)

#define NN_DETAIL_AOC_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Error, 0, format, args)
#define NN_DETAIL_AOC_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Error, 1, format, args)
#define NN_DETAIL_AOC_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Error, 2, format, args)
#define NN_DETAIL_AOC_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Error, 3, format, args)

#define NN_DETAIL_AOC_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Fatal, 0, format, args)
#define NN_DETAIL_AOC_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Fatal, 1, format, args)
#define NN_DETAIL_AOC_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Fatal, 2, format, args)
#define NN_DETAIL_AOC_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(aoc, Fatal, 3, format, args)

#define NN_DETAIL_AOC_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Trace, 0, text, length)
#define NN_DETAIL_AOC_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Trace, 1, text, length)
#define NN_DETAIL_AOC_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Trace, 2, text, length)
#define NN_DETAIL_AOC_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Trace, 3, text, length)

#define NN_DETAIL_AOC_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Info, 0, text, length)
#define NN_DETAIL_AOC_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Info, 1, text, length)
#define NN_DETAIL_AOC_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Info, 2, text, length)
#define NN_DETAIL_AOC_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Info, 3, text, length)

#define NN_DETAIL_AOC_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Warn, 0, text, length)
#define NN_DETAIL_AOC_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Warn, 1, text, length)
#define NN_DETAIL_AOC_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Warn, 2, text, length)
#define NN_DETAIL_AOC_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Warn, 3, text, length)

#define NN_DETAIL_AOC_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Error, 0, text, length)
#define NN_DETAIL_AOC_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Error, 1, text, length)
#define NN_DETAIL_AOC_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Error, 2, text, length)
#define NN_DETAIL_AOC_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Error, 3, text, length)

#define NN_DETAIL_AOC_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Fatal, 0, text, length)
#define NN_DETAIL_AOC_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Fatal, 1, text, length)
#define NN_DETAIL_AOC_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Fatal, 2, text, length)
#define NN_DETAIL_AOC_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(aoc, Fatal, 3, text, length)
